/*
 * Decompiled with CFR 0.152.
 */
package automata.ast;

import automata.ast.FunCall;
import automata.ast.IVisitor;
import automata.ast.Node;
import automata.util.Pretty;
import java.util.LinkedList;
import java.util.List;

public class Action
extends Node {
    public List<FunCall> calls;

    public Action(List<FunCall> calls) {
        this.calls = calls;
    }

    @Override
    Object accept(IVisitor visitor) {
        visitor.enter(this);
        LinkedList<Object> list = new LinkedList<Object>();
        for (FunCall call : this.calls) {
            Object o = call.accept(visitor);
            list.add(o);
        }
        return visitor.exit(this, list);
    }

    public String toString() {
        LinkedList<String> strings = new LinkedList<String>();
        for (FunCall funcall : this.calls) {
            strings.add(String.valueOf(funcall.percent()) + funcall.toString());
        }
        return Pretty.separate_with(strings, " / ");
    }
}

