/*
 * Decompiled with CFR 0.152.
 */
package automata.ast;

import automata.ast.AST;
import automata.ast.Action;
import automata.ast.Automaton;
import automata.ast.Behaviour;
import automata.ast.BinaryOp;
import automata.ast.Category;
import automata.ast.Condition;
import automata.ast.Direction;
import automata.ast.FunCall;
import automata.ast.IVisitor;
import automata.ast.Key;
import automata.ast.Mode;
import automata.ast.Node;
import automata.ast.State;
import automata.ast.Transition;
import automata.ast.UnaryOp;
import automata.ast.Underscore;
import automata.ast.Value;
import automata.util.Dot;
import java.util.List;

public class AstPrinter
implements IVisitor {
    StringBuilder nodes = new StringBuilder();
    StringBuilder edges = new StringBuilder();

    public String to_dot() {
        return Dot.graph("ast", this.nodes + "\n" + this.edges);
    }

    protected void dot_node(int id, String label, String options) {
        this.nodes.append(Dot.declare_node(id, label, options));
    }

    protected void dot_non_terminal_node(int id, String label) {
        this.dot_node(id, label, "shape=box, fontsize=8");
    }

    protected void dot_terminal_node(int id, String label) {
        this.dot_node(id, Dot.asString(label), "shape=none, fontname=times,  fontsize=12, fontcolor=blue");
    }

    protected void dot_keyword_node(int id, String label) {
        this.dot_node(id, label, "shape=none, fontname=comic, fontsize=12, fontcolor=orange");
    }

    protected void edge(int src_id, int tgt_id) {
        this.edges.append(Dot.edge((Integer)src_id, (Integer)tgt_id));
    }

    protected void non_terminal(Node node, String name) {
        this.dot_non_terminal_node(node.id, name);
    }

    protected void identifier(Node node, String name) {
        this.dot_non_terminal_node(node.id, name);
        this.edge(node.id, -node.id);
        this.dot_terminal_node(-node.id, node.toString());
    }

    protected void keyword(Node node, String name) {
        this.dot_non_terminal_node(node.id, name);
        this.edge(node.id, -node.id);
        this.dot_keyword_node(-node.id, node.toString());
    }

    protected void subtree(Node node, List<Integer> son_ids) {
        for (Integer id : son_ids) {
            this.edge(node.id, id);
        }
    }

    @Override
    public Object visit(BinaryOp operator, Object left, Object right) {
        this.non_terminal(operator, "BinaryOp");
        this.edge(operator.id, (Integer)left);
        this.edge(operator.id, (Integer)right);
        return operator.id;
    }

    @Override
    public Object visit(UnaryOp operator, Object expr) {
        this.non_terminal(operator, "UnaryOp");
        this.edge(operator.id, (Integer)expr);
        return operator.id;
    }

    @Override
    public void enter(FunCall funcall) {
        this.non_terminal(funcall, "FunCall");
        this.edge(funcall.id, -funcall.id);
        this.dot_keyword_node(-funcall.id, funcall.name);
    }

    @Override
    public Object exit(FunCall funcall, List<Object> parameters) {
        this.subtree(funcall, parameters);
        return funcall.id;
    }

    @Override
    public Object visit(Category terminal) {
        this.keyword(terminal, "Category");
        return terminal.id;
    }

    @Override
    public Object visit(Direction terminal) {
        this.keyword(terminal, "Direction");
        return terminal.id;
    }

    @Override
    public Object visit(Key terminal) {
        this.keyword(terminal, "Key");
        return terminal.id;
    }

    @Override
    public Object visit(Underscore u) {
        return null;
    }

    @Override
    public Object visit(Value value) {
        return null;
    }

    @Override
    public void enter(Action action) {
    }

    @Override
    public Object exit(Action action, List<Object> funcalls) {
        this.non_terminal(action, "Action");
        this.subtree(action, funcalls);
        return action.id;
    }

    @Override
    public Object visit(Behaviour behaviour, List<Object> transitions) {
        this.non_terminal(behaviour, "Behaviour");
        this.subtree(behaviour, transitions);
        return behaviour.id;
    }

    @Override
    public Object visit(State state) {
        this.identifier(state, "State");
        return state.id;
    }

    @Override
    public Object visit(Transition transition, Object condition, Object action, Object target) {
        this.non_terminal(transition, "Transition");
        this.edge(transition.id, (Integer)condition);
        this.edge(transition.id, (Integer)action);
        this.edge(transition.id, (Integer)target);
        return transition.id;
    }

    @Override
    public void enter(Automaton automaton) {
        this.non_terminal(automaton, "Automaton");
        this.edge(automaton.id, -automaton.id);
        this.dot_terminal_node(-automaton.id, automaton.name);
    }

    @Override
    public Object exit(Automaton automaton, Object initial_state, List<Object> modes) {
        this.edge(automaton.id, (Integer)initial_state);
        this.subtree(automaton, modes);
        return automaton.id;
    }

    @Override
    public Object visit(AST bot, List<Object> automata) {
        this.non_terminal(bot, "AST");
        this.subtree(bot, automata);
        return bot.id;
    }

    @Override
    public void enter(Mode mode) {
    }

    @Override
    public Object exit(Mode mode, Object state, Object behaviour) {
        this.non_terminal(mode, "Mode");
        this.edge(mode.id, (Integer)state);
        this.edge(mode.id, (Integer)behaviour);
        return mode.id;
    }

    @Override
    public void enter(Condition condition) {
    }

    @Override
    public Object exit(Condition condition, Object expr) {
        this.non_terminal(condition, "Condition");
        this.edge(condition.id, (Integer)expr);
        return condition.id;
    }
}

