/*
 * Decompiled with CFR 0.152.
 */
package automata.ast;

import automata.ast.AST;
import automata.ast.Action;
import automata.ast.Automaton;
import automata.ast.Behaviour;
import automata.ast.BinaryOp;
import automata.ast.Category;
import automata.ast.Condition;
import automata.ast.Direction;
import automata.ast.FunCall;
import automata.ast.IVisitor;
import automata.ast.Key;
import automata.ast.Mode;
import automata.ast.State;
import automata.ast.Transition;
import automata.ast.UnaryOp;
import automata.ast.Underscore;
import automata.ast.Value;
import com.rymeco.daam.automata.AutBehaviour;
import com.rymeco.daam.automata.AutState;
import com.rymeco.daam.automata.AutTransition;
import com.rymeco.daam.automata.Automata;
import com.rymeco.daam.automata.actions.AbsAction;
import com.rymeco.daam.automata.actions.ActDrop;
import com.rymeco.daam.automata.actions.ActEgg;
import com.rymeco.daam.automata.actions.ActExplode;
import com.rymeco.daam.automata.actions.ActGet;
import com.rymeco.daam.automata.actions.ActHit;
import com.rymeco.daam.automata.actions.ActJump;
import com.rymeco.daam.automata.actions.ActMove;
import com.rymeco.daam.automata.actions.ActPick;
import com.rymeco.daam.automata.actions.ActPop;
import com.rymeco.daam.automata.actions.ActPower;
import com.rymeco.daam.automata.actions.ActProtect;
import com.rymeco.daam.automata.actions.ActStore;
import com.rymeco.daam.automata.actions.ActTurn;
import com.rymeco.daam.automata.actions.ActWait;
import com.rymeco.daam.automata.actions.ActWizz;
import com.rymeco.daam.automata.conditions.AutBinaryOp;
import com.rymeco.daam.automata.conditions.AutUnaryOp;
import com.rymeco.daam.automata.conditions.CondCell;
import com.rymeco.daam.automata.conditions.CondClosest;
import com.rymeco.daam.automata.conditions.CondGotPower;
import com.rymeco.daam.automata.conditions.CondGotStuff;
import com.rymeco.daam.automata.conditions.CondKey;
import com.rymeco.daam.automata.conditions.CondMyDir;
import com.rymeco.daam.automata.conditions.CondTrue;
import com.rymeco.daam.automata.conditions.ICondition;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AutBuilder
implements IVisitor {
    PrintStream ps;
    AutState current_source_state;
    private Map<String, AutState> state_map;

    AutState state_id(State state) {
        AutState stored_state = this.state_map.get(state.name);
        if (stored_state != null) {
            return stored_state;
        }
        AutState s = new AutState(state.id, state.name);
        this.state_map.put(state.name, s);
        return s;
    }

    public AutBuilder(PrintStream ps, AST bot) {
        this.ps = ps;
        this.state_map = new HashMap<String, AutState>();
    }

    @Override
    public Object visit(Category cat) {
        return cat.toString();
    }

    @Override
    public Object visit(Direction dir) {
        return dir.toString();
    }

    @Override
    public Object visit(Key key) {
        return key.toString();
    }

    @Override
    public Object visit(Value v) {
        return v.toString();
    }

    @Override
    public Object visit(Underscore u) {
        return u.toString();
    }

    @Override
    public void enter(FunCall funcall) {
    }

    @Override
    public Object exit(FunCall funcall, List<Object> params) {
        ArrayList<String> p = new ArrayList<String>();
        for (Object param : params) {
            p.add(param.toString());
        }
        if (p.size() == 0) {
            p.add("F");
        }
        switch (funcall.name) {
            case "Move": {
                return new ActMove((String)p.get(0), funcall.percent);
            }
            case "Explode": {
                return new ActExplode(funcall.percent);
            }
            case "Pop": {
                return new ActPop((String)p.get(0), funcall.percent);
            }
            case "Wizz": {
                return new ActWizz((String)p.get(0), funcall.percent);
            }
            case "Wait": {
                return new ActWait(funcall.percent);
            }
            case "Jump": {
                return new ActJump((String)p.get(0), funcall.percent);
            }
            case "Turn": {
                return new ActTurn((String)p.get(0), funcall.percent);
            }
            case "Hit": {
                return new ActHit((String)p.get(0), funcall.percent);
            }
            case "Protect": {
                return new ActProtect((String)p.get(0), funcall.percent);
            }
            case "Pick": {
                return new ActPick((String)p.get(0), funcall.percent);
            }
            case "Drop": {
                return new ActDrop((String)p.get(0), funcall.percent);
            }
            case "Store": {
                return new ActStore(funcall.percent);
            }
            case "Get": {
                return new ActGet(funcall.percent);
            }
            case "Power": {
                return new ActPower(funcall.percent);
            }
            case "Egg": {
                return new ActEgg((String)p.get(0), funcall.percent);
            }
            case "Cell": {
                return new CondCell((String)p.get(0), (String)p.get(1));
            }
            case "Closest": {
                return new CondClosest((String)p.get(0), (String)p.get(1));
            }
            case "GotPower": {
                return new CondGotPower();
            }
            case "GotStuff": {
                return new CondGotStuff();
            }
            case "Key": {
                return new CondKey((String)p.get(0));
            }
            case "MyDir": {
                return new CondMyDir((String)p.get(0));
            }
            case "True": {
                return new CondTrue();
            }
        }
        return null;
    }

    @Override
    public Object visit(BinaryOp operator, Object left, Object right) {
        return new AutBinaryOp(operator.operator.charAt(0), (ICondition)left, (ICondition)right);
    }

    @Override
    public Object visit(UnaryOp operator, Object exp) {
        return new AutUnaryOp(operator.operator.charAt(0), (ICondition)exp);
    }

    @Override
    public Object visit(State state) {
        return this.state_id(state);
    }

    @Override
    public void enter(Mode mode) {
        this.current_source_state = this.state_id(mode.state);
    }

    @Override
    public Object exit(Mode mode, Object source_state, Object behaviour) {
        AutState s = (AutState)source_state;
        s.setBehaviour((AutBehaviour)behaviour);
        return s;
    }

    @Override
    public void enter(Condition condition) {
    }

    @Override
    public Object exit(Condition condition, Object exp) {
        return (ICondition)exp;
    }

    @Override
    public void enter(Action action) {
    }

    @Override
    public Object exit(Action action, List<Object> funcalls) {
        ArrayList<AbsAction> actions = new ArrayList<AbsAction>();
        for (Object a : funcalls) {
            actions.add((AbsAction)a);
        }
        return actions;
    }

    @Override
    public Object visit(Transition transition, Object condition, Object action, Object target) {
        ArrayList actions2 = (ArrayList)action;
        return new AutTransition((ICondition)condition, actions2, (AutState)target);
    }

    @Override
    public Object visit(Behaviour behaviour, List<Object> transitions) {
        AutBehaviour b = new AutBehaviour();
        for (Object t : transitions) {
            b.addTransition((AutTransition)t);
        }
        return b;
    }

    @Override
    public void enter(Automaton automaton) {
        this.state_map.clear();
    }

    @Override
    public Object exit(Automaton automaton, Object initial_state, List<Object> modes) {
        Automata a = new Automata((AutState)initial_state, automaton.name);
        for (Object s : modes) {
            a.addState((AutState)s);
        }
        return a;
    }

    @Override
    public Object visit(AST bot, List<Object> automata) {
        return automata.get(0);
    }
}

