/*
 * Decompiled with CFR 0.152.
 */
package automata.ast;

import automata.ast.AST;
import automata.ast.Action;
import automata.ast.Automaton;
import automata.ast.Behaviour;
import automata.ast.BinaryOp;
import automata.ast.Category;
import automata.ast.Condition;
import automata.ast.Direction;
import automata.ast.FunCall;
import automata.ast.IVisitor;
import automata.ast.Key;
import automata.ast.Mode;
import automata.ast.Node;
import automata.ast.State;
import automata.ast.Transition;
import automata.ast.UnaryOp;
import automata.ast.Underscore;
import automata.ast.Value;
import automata.util.Dot;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AutPrinter
implements IVisitor {
    PrintStream ps;
    Integer current_source_state;
    private Map<String, State> state_map;

    Integer state_id(State state) {
        State stored_state = this.state_map.get(state.name);
        if (stored_state != null) {
            return stored_state.id;
        }
        this.state_map.put(state.name, state);
        return state.id;
    }

    void print_state_map() {
        for (State state : this.state_map.values()) {
            this.state_node(state);
        }
    }

    public AutPrinter(PrintStream ps, AST bot) {
        this.ps = ps;
        this.state_map = new HashMap<String, State>();
        Dot.start_graph(this.ps, "bot");
        bot.accept(this);
        Dot.end_graph(this.ps, "bot");
    }

    public void new_subgraph(Automaton automaton) {
        Dot.start_subgraph(this.ps, automaton.name);
    }

    public void end_subgraph(Automaton automaton) {
        Dot.end_graph(this.ps, automaton.name);
    }

    void edge(int source, int target) {
        this.ps.print(Dot.edge((Integer)source, (Integer)target));
    }

    void node(Node node, String options) {
        this.ps.println(Dot.declare_node(node.id, node.toString(), options));
    }

    void state_node(State state) {
        this.node(state, "shape=circle, style=filled, fontsize=5");
    }

    void automaton_node(Automaton automaton) {
        this.node(automaton, "shape=none, fontname=times, fontsize=12, fontcolor=blue");
    }

    void transition_node(Transition transition) {
        this.node(transition, "shape=box, fontname=comic, fontsize=10");
    }

    @Override
    public Object visit(Category cat) {
        return null;
    }

    @Override
    public Object visit(Direction dir) {
        return null;
    }

    @Override
    public Object visit(Key key) {
        return null;
    }

    @Override
    public Object visit(Value v) {
        return null;
    }

    @Override
    public Object visit(Underscore u) {
        return null;
    }

    @Override
    public void enter(FunCall funcall) {
    }

    @Override
    public Object exit(FunCall funcall, List<Object> params) {
        return null;
    }

    @Override
    public Object visit(BinaryOp operator, Object left, Object right) {
        return null;
    }

    @Override
    public Object visit(UnaryOp operator, Object exp) {
        return null;
    }

    @Override
    public Object visit(State state) {
        return this.state_id(state);
    }

    @Override
    public void enter(Mode mode) {
        this.current_source_state = this.state_id(mode.state);
    }

    @Override
    public Object exit(Mode mode, Object source_state, Object behaviour) {
        return null;
    }

    @Override
    public void enter(Condition condition) {
    }

    @Override
    public Object exit(Condition condition, Object exp) {
        return null;
    }

    @Override
    public void enter(Action action) {
    }

    @Override
    public Object exit(Action action, List<Object> funcalls) {
        return null;
    }

    @Override
    public Object visit(Transition transition, Object condition, Object action, Object target) {
        this.transition_node(transition);
        this.edge(this.current_source_state, transition.id);
        this.edge(transition.id, (Integer)target);
        return transition.id;
    }

    @Override
    public Object visit(Behaviour behaviour, List<Object> transitions) {
        return null;
    }

    @Override
    public void enter(Automaton automaton) {
        this.state_map.clear();
        Dot.start_subgraph(this.ps, automaton.name);
        this.automaton_node(automaton);
    }

    @Override
    public Object exit(Automaton automaton, Object initial_state, List<Object> modes) {
        this.edge(automaton.id, (Integer)initial_state);
        this.print_state_map();
        Dot.end_graph(this.ps, automaton.name);
        return null;
    }

    @Override
    public Object visit(AST bot, List<Object> automata) {
        return null;
    }
}

