/*
 * Decompiled with CFR 0.152.
 */
package automata.ast;

import automata.ast.Expression;
import automata.ast.IVisitor;
import automata.ast.Parameter;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class FunCall
extends Expression {
    static final int NO_PERCENT = -1;
    public int percent;
    public String name;
    public List<Parameter> parameters;

    public FunCall(String name, List<Parameter> parameters) {
        this.percent = -1;
        this.name = name;
        this.parameters = parameters;
    }

    public FunCall(int percent, String name, List<Parameter> parameters) {
        this.percent = percent;
        this.name = name;
        this.parameters = parameters;
    }

    public String percent() {
        switch (this.percent) {
            case 100: {
                return "";
            }
            case -1: {
                return "_%";
            }
        }
        return String.valueOf(this.percent) + "%";
    }

    @Override
    public String toString() {
        String s = String.valueOf(this.percent) + "%" + this.name;
        if (this.parameters.size() > 0) {
            s = String.valueOf(s) + "(";
            ListIterator<Parameter> iterator = this.parameters.listIterator();
            while (iterator.hasNext()) {
                s = String.valueOf(s) + iterator.next().toString();
                if (!iterator.hasNext()) continue;
                s = String.valueOf(s) + ",";
            }
            s = String.valueOf(s) + ")";
        }
        return s;
    }

    @Override
    Object accept(IVisitor visitor) {
        visitor.enter(this);
        LinkedList<Object> list = new LinkedList<Object>();
        for (Parameter parameter : this.parameters) {
            Object o = parameter.accept(visitor);
            list.add(o);
        }
        return visitor.exit(this, list);
    }
}

