/*
 * Decompiled with CFR 0.152.
 */
package automata.util;

import java.io.PrintStream;

public final class Dot {
    public static String graph(String name, String content) {
        String output = new String();
        output = String.valueOf(output) + "digraph " + name + "{";
        output = String.valueOf(output) + "\nnode[shape=box, fontsize=16, color=gray];";
        output = String.valueOf(output) + "\n" + content;
        output = String.valueOf(output) + "\n}";
        return output;
    }

    public static String subgraph(String name, String content) {
        String output = new String();
        output = String.valueOf(output) + "\n\nsubgraph cluster_" + name;
        output = String.valueOf(output) + "{\n";
        output = String.valueOf(output) + content;
        output = String.valueOf(output) + "\n}\n";
        return output;
    }

    public static String subgraph(int id, String content) {
        return Dot.subgraph("" + id, content);
    }

    public static void start_graph(PrintStream ps, String name) {
        String string = new String();
        string = String.valueOf(string) + "digraph " + name + "{";
        string = String.valueOf(string) + "\nnode[shape=box, fontsize=16, color=gray];";
        ps.println(string);
    }

    public static void start_subgraph(PrintStream ps, String name) {
        ps.println("\n\nsubgraph cluster_" + name + "{");
    }

    public static void end_graph(PrintStream ps, String name) {
        ps.println("\n} // end of " + name);
    }

    public static String asString(String string) {
        return "\\\"" + string + "\\\"";
    }

    public static String quote(String string) {
        return "\"" + string + "\"";
    }

    private static String quote(int i) {
        return Dot.quote("" + i);
    }

    private static String node_label(String label, String options) {
        return " [label=" + Dot.quote(label) + ", " + options + "]";
    }

    public static String declare_node(Integer id, String label, String options) {
        return "\n" + Dot.quote(id) + Dot.node_label(label, options) + ";";
    }

    public static String declare_node(String id, String label, String options) {
        return "\n" + Dot.quote(id) + Dot.node_label(label, options) + ";";
    }

    public static String edge(String id1, String id2) {
        return "\n" + Dot.quote(id1) + " -> " + Dot.quote(id2) + ";";
    }

    public static String edge(Integer id1, Integer id2) {
        return "\n" + Dot.quote(id1) + " -> " + Dot.quote(id2) + ";";
    }

    public static String edge(String id1, Integer id2) {
        return "\n" + Dot.quote(id1) + " -> " + Dot.quote(id2) + ";";
    }

    public static String edge(Integer id1, String id2) {
        return "\n" + Dot.quote(id1) + " -> " + Dot.quote(id2) + ";";
    }

    public static String edge(String id1, String id2, String options) {
        return "\n" + Dot.quote(id1) + " -> " + Dot.quote(id2) + "[" + options + "];";
    }

    public static String edge(Integer id1, Integer id2, String options) {
        return "\n" + Dot.quote(id1) + " -> " + Dot.quote(id2) + "[" + options + "];";
    }

    public static String edge(String id1, Integer id2, String options) {
        return "\n" + Dot.quote(id1) + " -> " + Dot.quote(id2) + "[" + options + "];";
    }

    public static String edge(Integer id1, String id2, String options) {
        return "\n" + Dot.quote(id1) + " -> " + Dot.quote(id2) + "[" + options + "];";
    }
}

