/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam;

import automata.ast.AST;
import automata.ast.AutBuilder;
import automata.parser.AutomataParser;
import automata.parser.ParseException;
import com.rymeco.daam.GameConsts;
import com.rymeco.daam.automata.Automata;
import com.rymeco.daam.controller.CtrGame;
import com.rymeco.daam.controller.CtrTeleporter;
import com.rymeco.daam.controller.enemies.CtrLava;
import com.rymeco.daam.controller.items.CtrItmAmmoRailgun;
import com.rymeco.daam.controller.items.CtrItmAmmoRocket;
import com.rymeco.daam.controller.items.CtrItmAmmoShotgun;
import com.rymeco.daam.controller.items.CtrItmChicken;
import com.rymeco.daam.controller.items.CtrItmHeal;
import com.rymeco.daam.model.CylinderMap;
import com.rymeco.daam.model.Ground;
import com.rymeco.daam.model.Rock;
import com.rymeco.daam.model.Wave;
import com.rymeco.daam.util.Vector2;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;
import org.json.JSONArray;
import org.json.JSONObject;

public class AssetManager {
    private static HashMap<String, BufferedImage> textures;
    private static HashMap<String, URL> audio;
    private static HashMap<String, Automata> gal;
    private static HashMap<String, URL> maps;
    private static final ClassLoader CCL;

    static {
        CCL = Thread.currentThread().getContextClassLoader();
    }

    public static void loadAssets() throws IOException {
        String key;
        textures = new HashMap();
        audio = new HashMap();
        gal = new HashMap();
        maps = new HashMap();
        for (Asset asset : AssetManager.getFilesList("audio")) {
            key = asset.name.substring(0, asset.name.lastIndexOf(46));
            audio.put(key, asset.url);
        }
        for (Asset asset : AssetManager.getFilesList("textures")) {
            key = asset.name.substring(0, asset.name.lastIndexOf(46));
            textures.put(key, ImageIO.read(asset.url.openStream()));
        }
        for (Asset asset : AssetManager.getFilesList("gal")) {
            try {
                AST ast = new AutomataParser(asset.url.openStream()).Run();
                AutBuilder visitor = new AutBuilder(System.out, ast);
                Automata a = (Automata)ast.accept(visitor);
                String key2 = asset.name.substring(0, asset.name.lastIndexOf(46));
                gal.put(key2, a);
            }
            catch (ParseException e) {
                throw new IOException(e.getCause());
            }
        }
        for (Asset asset : AssetManager.getFilesList("maps")) {
            key = asset.name.substring(0, asset.name.lastIndexOf(46));
            maps.put(key, asset.url);
        }
    }

    public static Set<String> availableTextures() {
        return textures.keySet();
    }

    public static Set<String> availableAudio() {
        return audio.keySet();
    }

    public static Set<String> availableGAL() {
        return gal.keySet();
    }

    public static Set<String> availableMaps() {
        return maps.keySet();
    }

    public static BufferedImage getTexture(String name) {
        return textures.get(name);
    }

    public static BufferedInputStream getAudio(String name) {
        try {
            return new BufferedInputStream(audio.get(name).openStream());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Automata getGAL(String name) {
        return gal.get(name);
    }

    public static URL getMap(String name) {
        return maps.get(name);
    }

    private static Set<Asset> getFilesList(String dir) throws IOException {
        HashSet<Asset> assets = new HashSet<Asset>();
        try {
            Path p;
            URI uri = CCL.getResource(dir).toURI();
            FileSystem fs = null;
            if (uri.toString().startsWith("jar:")) {
                String[] loc = uri.toString().split("!");
                fs = FileSystems.newFileSystem(URI.create(loc[0]), new HashMap());
                p = fs.getPath(loc[1], new String[0]);
            } else {
                p = Paths.get(uri);
            }
            Object[] objectArray = Files.list(p).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                Path path = (Path)o;
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    String name = path.getFileName().toString();
                    URL url = CCL.getResource(String.valueOf(dir) + "/" + name);
                    Asset asset = new Asset(url, name);
                    assets.add(asset);
                }
                ++n2;
            }
            if (fs != null) {
                fs.close();
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return assets;
    }

    private static class Asset {
        public final URL url;
        public final String name;

        public Asset(URL url, String name) {
            this.url = url;
            this.name = name;
        }
    }

    public static class MapLoader {
        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public static CylinderMap loadMap(String name, BufferedImage tileset, CtrGame ctrGame) {
            block30: {
                url = AssetManager.getMap(name);
                try {
                    src = new String(url.openStream().readAllBytes());
                    obj = new JSONObject(src);
                    spawn = obj.getJSONObject("player");
                    sx = spawn.getFloat("x");
                    sy = spawn.getFloat("y");
                    rows = obj.getJSONArray("tiles");
                    h = rows.length();
                    w = rows.getJSONArray(0).length();
                    map = new CylinderMap(w, h);
                    map.setSpawn(new Vector2(sx, sy));
                    y = 0;
                    while (y < h) {
                        cols = rows.getJSONArray(y);
                        x = 0;
                        while (x < w) {
                            id = cols.getInt(x);
                            switch (id) {
                                case 2: {
                                    map.addEnemy(new CtrLava(x * 16, y * 16, tileset, ctrGame, -1));
                                }
                                default: {
                                    tile /* !! */  = new Ground(x * 16, y * 16, tileset);
                                    break;
                                }
                                case 1: {
                                    tile /* !! */  = new Rock(x * 16, y * 16, tileset);
                                }
                            }
                            map.setTile(x, y, tile /* !! */ );
                            ++x;
                        }
                        ++y;
                    }
                    waves = obj.getJSONArray("waves");
                    for (Object waveO : waves) {
                        waveArr = (JSONArray)waveO;
                        wave = new Wave();
                        for (Object enemO : waveArr) {
                            enem = (JSONObject)enemO;
                            id = enem.getInt("id");
                            x = enem.getInt("x");
                            y = enem.getInt("y");
                            eid = null;
                            switch (id) {
                                case 0: {
                                    eid = GameConsts.EnemyID.ZOMBIE;
                                    break;
                                }
                                case 1: {
                                    eid = GameConsts.EnemyID.GASTEROLCAN;
                                    break;
                                }
                                case 2: {
                                    eid = GameConsts.EnemyID.LAVA_BLOB;
                                    break;
                                }
                                case 3: {
                                    eid = GameConsts.EnemyID.TRAMOID;
                                    break;
                                }
                                case 4: {
                                    eid = GameConsts.EnemyID.SATAN;
                                }
                            }
                            if (eid == null) continue;
                            wave.addEnemy(new Wave.EnemyStruct(eid, x, y));
                        }
                        map.addWave(wave);
                    }
                    id_list = new HashMap<Integer, CtrTeleporter>();
                    teleporters = obj.getJSONArray("teleporters");
                    for (E o : teleporters) {
                        jsonItem = (JSONObject)o;
                        id = jsonItem.getInt("id");
                        x = jsonItem.getInt("x") * 16;
                        y = jsonItem.getInt("y") * 16;
                        teleporterAuto = AssetManager.getGAL("teleporter");
                        tele = new CtrTeleporter(tileset, ctrGame, new Vector2(x, y));
                        tele.setTarget(ctrGame.getPlayer());
                        tele.setAutomata(teleporterAuto);
                        tele.setState(teleporterAuto.getInit());
                        if (id_list.get(id) != null) {
                            tele.setDestination(((CtrTeleporter)id_list.get(id)).getTeleporter());
                            ((CtrTeleporter)id_list.get(id)).setDestination(tele.getTeleporter());
                            id_list.remove(id);
                        } else {
                            id_list.put(id, tele);
                        }
                        map.addTeleporter(tele);
                    }
                    items = obj.getJSONArray("items");
                    for (Object o : items) {
                        jsonItem = (JSONObject)o;
                        id = jsonItem.getInt("id");
                        x = jsonItem.getInt("x") * 16;
                        y = jsonItem.getInt("y") * 16;
                        ctrItem /* !! */  = null;
                        switch (id) {
                            case 0: {
                                ctrItem /* !! */  = new CtrItmChicken(tileset, false, 0);
                                break;
                            }
                            case 1: {
                                ctrItem /* !! */  = new CtrItmHeal(tileset, false, 0);
                                break;
                            }
                            case 2: {
                                ctrItem /* !! */  = new CtrItmAmmoRailgun(tileset, false, 0);
                                break;
                            }
                            case 3: {
                                ctrItem /* !! */  = new CtrItmAmmoShotgun(tileset, false, 0);
                                break;
                            }
                            case 4: {
                                ctrItem /* !! */  = new CtrItmAmmoRocket(tileset, false, 0);
                            }
                        }
                        if (ctrItem /* !! */  == null) continue;
                        ctrItem /* !! */ .setPosition(x, y);
                        map.addItem(ctrItem /* !! */ );
                    }
                    break block30;
                }
                catch (IOException e) {
                    map = new CylinderMap(64, 64);
                    y = 0;
                    ** while (y < 64)
                }
lbl-1000:
                // 1 sources

                {
                    x = 0;
                    while (x < 64) {
                        map.setTile(x, y, new Ground(x * 16, y * 16, tileset));
                        ++x;
                    }
                    ++y;
                    continue;
                }
            }
            return map;
        }
    }
}

