/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.automata;

import com.rymeco.daam.automata.AutState;
import com.rymeco.daam.automata.IEntity;
import com.rymeco.daam.automata.actions.AbsAction;
import com.rymeco.daam.automata.conditions.ICondition;
import java.util.ArrayList;
import java.util.Random;

public class AutTransition {
    private AutState dest;
    private ICondition cond;
    private ArrayList<AbsAction> actions;

    public AutTransition(AutState dest) {
        this.dest = dest;
        this.actions = new ArrayList();
    }

    public AutTransition(ICondition cond, ArrayList<AbsAction> actions, AutState dest) {
        this.dest = dest;
        this.cond = cond;
        this.actions = actions;
        if (this.getActions() != null) {
            this.calcIntervals();
        }
    }

    public AutState getDestination() {
        return this.dest;
    }

    public void setDestination(AutState dest) {
        this.dest = dest;
    }

    public ICondition getCondition() {
        return this.cond;
    }

    public void setCondition(ICondition cond) {
        this.cond = cond;
    }

    public boolean eval(IEntity entity) {
        return this.cond.eval(entity);
    }

    public ArrayList<AbsAction> getActions() {
        return this.actions;
    }

    public AbsAction getAction(int index) {
        return this.actions.get(index);
    }

    public AbsAction pickAction() {
        if (this.actions.size() == 0) {
            return null;
        }
        int i = 0;
        if (this.actions.size() > 1) {
            Random rand = new Random();
            int r = rand.nextInt(99);
            while (i < this.actions.size() - 1 && this.actions.get(i).getMaxInterval() < r) {
                ++i;
            }
        }
        return this.actions.get(i);
    }

    public void addAction(AbsAction action) {
        this.actions.add(action);
        if (this.actions.size() > 1) {
            this.calcIntervals();
        }
    }

    public void removeAction(AbsAction action) {
        this.actions.remove(action);
        if (this.actions.size() == 1) {
            this.actions.get(0).setProbInterval(0, 100);
        } else {
            this.calcIntervals();
        }
    }

    public void removeAction(int index) {
        this.actions.remove(index);
    }

    private void calcIntervals() {
        int probRest = 100;
        int noProb = 0;
        for (AbsAction action : this.actions) {
            int p = action.getProbability();
            if (p != -1) {
                probRest -= p;
                continue;
            }
            ++noProb;
        }
        int min = 0;
        int count = 0;
        for (AbsAction action : this.actions) {
            if (count == this.actions.size() - 1) {
                action.setProbInterval(min, 100);
                continue;
            }
            int p = action.getProbability();
            if (p == -1) {
                p = probRest / noProb;
            }
            action.setProbInterval(min, min + p);
            min += p;
            ++count;
        }
    }
}

