/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.automata;

import com.rymeco.daam.automata.AutState;
import com.rymeco.daam.automata.AutTransition;
import com.rymeco.daam.automata.IEntity;
import com.rymeco.daam.automata.actions.AbsAction;
import java.util.ArrayList;

public class Automata {
    private AutState init;
    private ArrayList<AutState> states;
    private String name;

    public Automata(AutState init, String name) {
        this.init = init;
        this.name = name;
        this.states = new ArrayList();
        this.states.add(init);
    }

    public AutState getInit() {
        return this.init;
    }

    public void setInit(AutState init) {
        this.init = init;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList<AutState> getStates() {
        return this.states;
    }

    public AutState getState(int index) {
        return this.states.get(index);
    }

    public void addState(AutState state) {
        if (!this.getStates().contains(state)) {
            this.states.add(state);
        }
    }

    public void removeState(AutState state) {
        this.states.remove(state);
    }

    public void removeState(int index) {
        this.states.remove(index);
    }

    public AutState step(IEntity entity, AutState currentState) {
        int i = 0;
        AutState nextState = currentState;
        while (i < currentState.getBehaviour().getTransitions().size() && !currentState.getBehaviour().getTransition(i).eval(entity)) {
            ++i;
        }
        if (i < currentState.getBehaviour().getTransitions().size()) {
            AutTransition t = currentState.getBehaviour().getTransition(i);
            AbsAction act = t.pickAction();
            if (act != null) {
                act.apply(entity);
            }
            nextState = t.getDestination();
        }
        return nextState;
    }
}

