/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.controller;

import com.rymeco.daam.automata.IEntity;
import com.rymeco.daam.controller.CtrGame;
import com.rymeco.daam.controller.CtrPlayer;
import com.rymeco.daam.controller.IController;
import com.rymeco.daam.controller.enemies.CtrEnemy;
import com.rymeco.daam.controller.enemies.CtrExplosion;
import com.rymeco.daam.controller.enemies.CtrLava;
import com.rymeco.daam.controller.enemies.CtrSatanClaus;
import com.rymeco.daam.model.AbsTiles;
import com.rymeco.daam.model.Bullet;
import com.rymeco.daam.model.HitBox;
import com.rymeco.daam.model.Weapon;
import com.rymeco.daam.util.Vector2;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class CtrBullet
implements IController {
    private long bulletElapsed;
    private ArrayList<Bullet> playerBullets;
    private BufferedImage tileset;
    private boolean initialized;
    private CtrPlayer ctrPlayer;
    private CtrGame ctrGame;

    public CtrBullet(BufferedImage tileset, CtrGame ctrGame) {
        this.tileset = tileset;
        this.ctrGame = ctrGame;
        this.playerBullets = new ArrayList();
        this.initialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void onTick(long elapsed) {
        this.updateBulletMovement(elapsed);
    }

    public ArrayList<Bullet> getBullets() {
        return this.playerBullets;
    }

    public void setCtrPlayer(CtrPlayer p) {
        this.ctrPlayer = p;
    }

    public CtrPlayer getCtrPlayer() {
        return this.ctrPlayer;
    }

    private void updateBulletMovement(long elapsed) {
        this.bulletElapsed += elapsed;
        if (this.bulletElapsed > 24L) {
            this.bulletElapsed = 0L;
            int i = 0;
            while (i < this.playerBullets.size()) {
                Bullet bullet = this.playerBullets.get(i);
                if (bullet != null) {
                    CtrEnemy enemyColision = this.enemyColi(bullet);
                    if (this.ctrPlayer != null && this.playerColi(bullet)) {
                        this.ctrPlayer.damage((int)bullet.getWeapon().getDamage());
                    }
                    if (enemyColision != null && !(enemyColision instanceof CtrLava)) {
                        enemyColision.damage((int)bullet.getWeapon().getDamage());
                        enemyColision.setHideTimer(0L);
                        if (bullet.getWeapon().getName().equals("rocketlauncher")) {
                            CtrExplosion c = new CtrExplosion(this.tileset, this.ctrGame);
                            this.ctrGame.createEnemy(c, enemyColision.getX(), enemyColision.getY());
                        }
                        if (enemyColision.getTarget() instanceof CtrPlayer) {
                            CtrPlayer p = (CtrPlayer)enemyColision.getTarget();
                            p.setBossAutomata(false);
                        }
                        if (!bullet.getWeapon().getName().equals("railgun")) {
                            this.playerBullets.remove(bullet);
                        } else if ((float)bullet.getElapsed() < bullet.getWeapon().getRange() && !this.tileColi(bullet) && !this.playerColi(bullet)) {
                            bullet.translate();
                            if (bullet.getX() >= (float)this.ctrGame.getMap().getWidth()) {
                                bullet.setX(0.0f);
                            } else if (bullet.getX() < 0.0f) {
                                bullet.setX(this.ctrGame.getMap().getWidth() - 1);
                            }
                            bullet.getHitBox().setX(bullet.getX());
                            bullet.getHitBox().setY(bullet.getY());
                        }
                    } else if ((float)bullet.getElapsed() < bullet.getWeapon().getRange() && !this.tileColi(bullet) && !this.playerColi(bullet)) {
                        bullet.translate();
                        if (bullet.getX() >= (float)this.ctrGame.getMap().getWidth()) {
                            bullet.setX(0.0f);
                        } else if (bullet.getX() < 0.0f) {
                            bullet.setX(this.ctrGame.getMap().getWidth() - 1);
                        }
                        bullet.getHitBox().setX(bullet.getX());
                        bullet.getHitBox().setY(bullet.getY());
                    } else {
                        this.playerBullets.remove(bullet);
                    }
                }
                ++i;
            }
        }
    }

    private CtrEnemy enemyColi(Bullet bullet) {
        for (CtrEnemy enemy : this.ctrGame.getEnemies()) {
            HitBox enemyBox = enemy.getHitBox();
            if (enemyBox == null) continue;
            HitBox enemyBox2 = null;
            if (enemyBox.getX() + enemyBox.getWidth() >= (float)this.ctrGame.getMap().getWidth()) {
                enemyBox2 = new HitBox(enemyBox.getX() - (float)this.ctrGame.getMap().getWidth(), enemyBox.getY(), enemyBox.getWidth(), enemyBox.getHeight());
            }
            if (!bullet.getHitBox().collide(enemyBox) && (enemyBox2 == null || !bullet.getHitBox().collide(enemyBox2)) || !bullet.getHitBox().collide(enemy.getHitBox()) || bullet.getWeapon().getName().equals("explosionbossgun") || bullet.getWeapon().getName().equals("bossgun")) continue;
            return enemy;
        }
        return null;
    }

    private boolean playerColi(Bullet bullet) {
        if (this.ctrPlayer == null) {
            return false;
        }
        HitBox playerBox = this.ctrPlayer.getHitBox();
        HitBox playerBox2 = null;
        if (playerBox.getX() + playerBox.getWidth() >= (float)this.ctrGame.getMap().getWidth()) {
            playerBox2 = new HitBox(playerBox.getX() - (float)this.ctrGame.getMap().getWidth(), playerBox.getY(), playerBox.getWidth(), playerBox.getHeight());
        }
        return bullet.getHitBox().collide(playerBox) || playerBox2 != null && bullet.getHitBox().collide(playerBox2);
    }

    private boolean tileColi(Bullet bullet) {
        AbsTiles tile = this.ctrGame.getMap().getTiles()[Math.floorMod((int)bullet.getY() / 16, this.ctrGame.getMap().getTileHeight())][Math.floorMod((int)bullet.getX() / 16, this.ctrGame.getMap().getTileWidth())];
        return tile != null && !tile.isWalkableThrough() && bullet.getHitBox().collide(tile.getHitBox());
    }

    public void bulletSpawn(IEntity entity, float angle, Weapon weapon) {
        if (entity instanceof CtrPlayer) {
            CtrPlayer ctrPlayer = (CtrPlayer)entity;
            Vector2 spawnPos = new Vector2();
            spawnPos.x = ctrPlayer.getPosition().x;
            spawnPos.y = ctrPlayer.getPosition().y;
            float x = this.ctrGame.getView().getCursorX() + (float)this.ctrGame.getView().getCamera().getX();
            float y = this.ctrGame.getView().getCursorY() + (float)this.ctrGame.getView().getCamera().getY();
            if (x > spawnPos.x + 16.0f) {
                spawnPos.x += 14.0f;
                spawnPos.y += 9.0f;
            } else if (x < spawnPos.x) {
                spawnPos.x -= 2.0f;
                spawnPos.y += 9.0f;
            } else if (y < spawnPos.y + 8.0f) {
                spawnPos.x += 6.0f;
                spawnPos.y -= 4.0f;
            } else {
                spawnPos.x += 6.0f;
                spawnPos.y += 16.0f;
            }
            Vector2 direction = new Vector2();
            direction.x = x - spawnPos.x;
            direction.y = y - spawnPos.y;
            direction.rotate(angle);
            direction.normalize();
            this.playerBullets.add(new Bullet(spawnPos, direction, this.tileset, weapon));
        } else if (entity instanceof CtrSatanClaus) {
            CtrSatanClaus ctrSatan = (CtrSatanClaus)entity;
            Vector2 spawnPos = new Vector2();
            spawnPos.x = ctrSatan.getPosition().x;
            spawnPos.y = ctrSatan.getPosition().y;
            float x = ctrSatan.getTarget().getPosition().x;
            float y = ctrSatan.getTarget().getPosition().y;
            if (x > spawnPos.x + 16.0f) {
                spawnPos.x += 14.0f;
                spawnPos.y += 9.0f;
            } else if (x < spawnPos.x) {
                spawnPos.x -= 2.0f;
                spawnPos.y += 9.0f;
            } else if (y < spawnPos.y + 8.0f) {
                spawnPos.x += 6.0f;
                spawnPos.y -= 4.0f;
            } else {
                spawnPos.x += 6.0f;
                spawnPos.y += 16.0f;
            }
            Vector2 direction = new Vector2();
            direction.x = x - spawnPos.x;
            direction.y = y - spawnPos.y;
            direction.rotate(angle);
            direction.normalize();
            this.playerBullets.add(new Bullet(spawnPos, direction, this.tileset, weapon));
        }
    }
}

