/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.controller;

import com.rymeco.daam.AssetManager;
import com.rymeco.daam.GameConsts;
import com.rymeco.daam.automata.Automata;
import com.rymeco.daam.controller.CtrMain;
import com.rymeco.daam.controller.CtrPlayer;
import com.rymeco.daam.controller.CtrTeleporter;
import com.rymeco.daam.controller.CtrWave;
import com.rymeco.daam.controller.IController;
import com.rymeco.daam.controller.enemies.CtrEnemy;
import com.rymeco.daam.controller.enemies.CtrSatanClaus;
import com.rymeco.daam.controller.items.CtrItem;
import com.rymeco.daam.controller.items.CtrItmAmmoRailgun;
import com.rymeco.daam.controller.items.CtrItmAmmoRocket;
import com.rymeco.daam.controller.items.CtrItmAmmoShotgun;
import com.rymeco.daam.controller.items.CtrItmChicken;
import com.rymeco.daam.controller.items.CtrItmHeal;
import com.rymeco.daam.model.AbsTiles;
import com.rymeco.daam.model.Bullet;
import com.rymeco.daam.model.CylinderMap;
import com.rymeco.daam.model.EnemyAutoStorage;
import com.rymeco.daam.model.Sprite;
import com.rymeco.daam.util.Vector2;
import com.rymeco.daam.util.events.IAudioListener;
import com.rymeco.daam.util.events.IKeyboardListener;
import com.rymeco.daam.util.events.IMouseBtnListener;
import com.rymeco.daam.util.events.IMouseMoveListener;
import com.rymeco.daam.view.ViewGame;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class CtrGame
implements IController,
IMouseBtnListener,
IMouseMoveListener,
IKeyboardListener,
IAudioListener {
    private BufferedImage tileset;
    public CylinderMap map;
    private ViewGame viewGame;
    private CtrMain ctrMain;
    private CtrPlayer ctrPlayer;
    private CtrWave ctrWave;
    private ArrayList<CtrEnemy> ctrEnemiesChange;
    private ArrayList<Vector2> enemiesPos;
    private ArrayList<Vector2> itemsPos;
    private ArrayList<Vector2> teleporterPos;
    private boolean initialized;
    private BufferedInputStream audioStream;
    private Automata playAuto;
    private Automata playBossAuto;
    private final boolean CHEAT_PLAYER_GODMODE;

    public CtrGame(CtrMain ctrMain) {
        this.CHEAT_PLAYER_GODMODE = ctrMain.isCodeValid();
        this.playAuto = AssetManager.getGAL("player");
        this.playBossAuto = AssetManager.getGAL("player_boss1");
        this.ctrMain = ctrMain;
        this.tileset = AssetManager.getTexture(GameConsts.TexFile.MAIN_TILESET.toString());
        this.viewGame = new ViewGame(ctrMain.getMainView().getCursorPos(), this);
        this.itemsPos = new ArrayList();
        this.enemiesPos = new ArrayList();
        this.ctrEnemiesChange = new ArrayList();
        this.teleporterPos = new ArrayList();
        this.ctrPlayer = new CtrPlayer(this.tileset, this);
        this.ctrPlayer.setAutomata(this.playAuto);
        this.ctrPlayer.setBossAutomata(this.playBossAuto);
        this.ctrPlayer.setState(this.playAuto.getInit());
        this.viewGame.setPlayerPos(this.ctrPlayer.getPosition());
        this.map = AssetManager.MapLoader.loadMap(GameConsts.MapFile.MAIN.toString(), this.tileset, this);
        this.ctrPlayer.setPosition(this.map.getSpawn());
        this.ctrPlayer.getHitBox().setPosition(this.ctrPlayer.getPosition());
        this.viewGame.setMap(this.map);
        for (CtrEnemy ctrEnemy : this.map.getEnemies()) {
            ctrEnemy.setTarget(this.ctrPlayer);
            this.enemiesPos.add(ctrEnemy.getPosition());
        }
        for (CtrItem ctrItem : this.map.getItems()) {
            this.itemsPos.add(ctrItem.getPosition());
        }
        for (CtrTeleporter ctrTeleporter : this.map.getTeleporters()) {
            this.teleporterPos.add(ctrTeleporter.getPosition());
        }
        this.ctrWave = new CtrWave(this);
        this.ctrWave.loadNextWave(this.tileset);
        int n = ctrMain.getMainView().getWidth();
        int h = ctrMain.getMainView().getHeight();
        this.viewGame.setSize(n, h);
        ctrMain.getMainView().setView(this.viewGame);
        this.audioStream = AssetManager.getAudio(GameConsts.AudioFile.F2N2.toString());
        this.playMusic();
        this.initialized = true;
    }

    public EnemyAutoStorage getAutoStorage() {
        return this.ctrMain.getAutoStorage();
    }

    public CylinderMap getMap() {
        return this.map;
    }

    public ArrayList<CtrEnemy> getEnemies() {
        return this.map.getEnemies();
    }

    public ArrayList<CtrItem> getItems() {
        return this.map.getItems();
    }

    public ArrayList<CtrTeleporter> getTeleporters() {
        return this.map.getTeleporters();
    }

    public ViewGame getView() {
        return this.viewGame;
    }

    public CtrPlayer getPlayer() {
        return this.ctrPlayer;
    }

    public void createItem(int x, int y, GameConsts.ItemID type, boolean despawn, int lifetime) {
        CtrItem item;
        switch (type) {
            default: {
                item = new CtrItmChicken(this.tileset, despawn, lifetime);
                break;
            }
            case HEAL: {
                item = new CtrItmHeal(this.tileset, despawn, lifetime);
                break;
            }
            case AMMO_RAILGUN: {
                item = new CtrItmAmmoRailgun(this.tileset, despawn, lifetime);
                break;
            }
            case AMMO_SHOTGUN: {
                item = new CtrItmAmmoShotgun(this.tileset, despawn, lifetime);
                break;
            }
            case AMMO_ROCKET: {
                item = new CtrItmAmmoRocket(this.tileset, despawn, lifetime);
            }
        }
        item.setPosition(x, y);
        this.map.addItem(item);
        this.itemsPos.add(item.getPosition());
    }

    public void createEnemy(CtrEnemy c, float x, float y) {
        c.setTarget(this.ctrPlayer);
        c.setState(c.getAutomata().getInit());
        c.setPosition(new Vector2(x, y));
        this.ctrEnemiesChange.add(c);
        this.enemiesPos.add(c.getPosition());
    }

    public void addEnemyPosition(Vector2 pos) {
        this.enemiesPos.add(pos);
    }

    public void removeEnemyPosition(Vector2 pos) {
        this.enemiesPos.remove(pos);
    }

    public ArrayList<Vector2> getEnemiesPositions() {
        return this.enemiesPos;
    }

    public ArrayList<Vector2> getTeleportersPositions() {
        return this.teleporterPos;
    }

    public void addItemPosition(Vector2 pos) {
        this.itemsPos.add(pos);
    }

    public void removeItemPosition(Vector2 pos) {
        this.itemsPos.remove(pos);
    }

    public ArrayList<Vector2> getItemsPositions() {
        return this.itemsPos;
    }

    private void shiftSprite(Sprite s, Vector2 realPos) {
        int camX = this.viewGame.getCamera().getX() - 16;
        float viewW = this.viewGame.getWidth() + 16;
        float x = realPos.x;
        if (realPos.x > (float)camX + viewW) {
            x = realPos.x - (float)this.map.getWidth();
        } else if (realPos.x < (float)camX) {
            x = realPos.x + (float)this.map.getWidth();
        }
        s.setX(x);
    }

    @Override
    public void onTick(long elapsed) {
        if (this.isInitialized()) {
            if (!this.ctrPlayer.gotPower() && !this.CHEAT_PLAYER_GODMODE) {
                this.ctrMain.setGameState(GameConsts.GameState.END_LOST);
            }
            if (this.ctrWave.waveEnded()) {
                if (this.ctrWave.hasNextWave()) {
                    this.ctrWave.loadNextWave(this.tileset);
                    this.viewGame.getMinimap().upWaveCounter();
                    this.viewGame.getMinimap().resetStartingTimer();
                } else {
                    this.ctrMain.setGameState(GameConsts.GameState.END_WON);
                }
            }
            if (this.viewGame.isInitialized()) {
                this.viewGame.onTick(elapsed);
            }
            this.ctrPlayer.onTick(elapsed);
            if (this.ctrMain.getMainView().getCursorPos().x + (float)this.viewGame.getCamera().getX() < this.ctrPlayer.getPosition().x + 8.0f) {
                this.ctrPlayer.getSprite().setFlipH(true);
            } else {
                this.ctrPlayer.getSprite().setFlipH(false);
            }
            for (CtrTeleporter t : this.map.getTeleporters()) {
                t.onTick(elapsed);
                if (!this.viewGame.canAddSprites()) continue;
                this.viewGame.addSprite(t.getSprite());
                this.shiftSprite(t.getSprite(), t.getPosition());
            }
            ArrayList<CtrEnemy> deadEnemies = new ArrayList<CtrEnemy>();
            for (CtrEnemy c : this.map.getEnemies()) {
                c.onTick(elapsed);
                if (c.getHealth() <= 0 && c.getCurrentState().getName().equals("")) {
                    deadEnemies.add(c);
                    this.enemiesPos.remove(c.getPosition());
                    this.ctrWave.removeEnemy(c.getEnemyID());
                    continue;
                }
                if (!this.viewGame.canAddSprites() || c.getSprite().isHidden()) continue;
                Iterator<Object> s = c.getSprite();
                if (c.getDirection().contains("W")) {
                    ((Sprite)((Object)s)).setFlipH(true);
                } else {
                    ((Sprite)((Object)s)).setFlipH(false);
                }
                this.shiftSprite((Sprite)((Object)s), c.getPosition());
                this.viewGame.addSprite((Sprite)((Object)s));
            }
            this.map.getEnemies().removeAll(deadEnemies);
            this.map.getEnemies().addAll(this.ctrEnemiesChange);
            this.ctrEnemiesChange.clear();
            ArrayList<CtrItem> deadItems = new ArrayList<CtrItem>();
            for (CtrItem ctrItem : this.map.getItems()) {
                ctrItem.onTick(elapsed);
                if (ctrItem.mustRemove()) {
                    deadItems.add(ctrItem);
                    this.itemsPos.remove(ctrItem.getItem().getPosition());
                    continue;
                }
                if (!this.viewGame.canAddSprites()) continue;
                this.shiftSprite(ctrItem.getSprite(), ctrItem.getPosition());
                this.viewGame.addSprite(ctrItem.getSprite());
                if (ctrItem.getSecondarySprite() == null) continue;
                this.shiftSprite(ctrItem.getSecondarySprite(), ctrItem.getPosition());
                this.viewGame.addSprite(ctrItem.getSecondarySprite());
            }
            this.map.getItems().removeAll(deadItems);
            if (this.viewGame.canAddSprites()) {
                for (Bullet bullet : this.ctrPlayer.getCtrBullet().getBullets()) {
                    this.shiftSprite(bullet.getSprite(), bullet.getPosition());
                    this.viewGame.addSprite(bullet.getSprite());
                }
                for (CtrEnemy ctrEnemy : this.map.getEnemies()) {
                    if (!(ctrEnemy instanceof CtrSatanClaus)) continue;
                    CtrSatanClaus ctrSatan = (CtrSatanClaus)ctrEnemy;
                    for (Bullet b : ctrSatan.getCtrBullet().getBullets()) {
                        this.shiftSprite(b.getSprite(), b.getPosition());
                        this.viewGame.addSprite(b.getSprite());
                    }
                }
                int n = this.viewGame.getCamera().getX() / 16 - 1;
                int minY = this.viewGame.getCamera().getY() / 16 - 1;
                int w = this.map.getTileWidth();
                int h = this.map.getTileHeight();
                int tilesX = this.viewGame.getWidth() / 16 + n + 3;
                int tilesY = minY + 16;
                int y = minY;
                while (y < tilesY) {
                    int x = n;
                    while (x < tilesX) {
                        int tx = Math.floorMod(x, w);
                        int ty = Math.floorMod(y, h);
                        AbsTiles tile = this.map.getTiles()[ty][tx];
                        if (tile != null) {
                            Sprite s = tile.getSprite();
                            s.setX(x * 16);
                            this.viewGame.addSprite(s);
                        }
                        ++x;
                    }
                    ++y;
                }
                if (!this.ctrPlayer.getSprite().isHidden()) {
                    this.viewGame.addSprite(this.ctrPlayer.getSprite());
                }
                this.viewGame.addSprite(this.ctrPlayer.getItemAnimSprite());
                this.viewGame.addSprite(this.ctrPlayer.getFireAnimSprite());
            }
            this.viewGame.stopAddSprites();
        }
    }

    @Override
    public void onKeyType(KeyEvent e) {
    }

    @Override
    public void onKeyPress(KeyEvent e) {
        switch (e.getExtendedKeyCode()) {
            case 90: {
                this.ctrPlayer.zPressed(true);
                break;
            }
            case 81: {
                this.ctrPlayer.qPressed(true);
                break;
            }
            case 83: {
                this.ctrPlayer.sPressed(true);
                break;
            }
            case 68: {
                this.ctrPlayer.dPressed(true);
                break;
            }
            case 32: {
                this.ctrPlayer.spacePressed(true);
            }
        }
    }

    @Override
    public void onKeyRelease(KeyEvent e) {
        switch (e.getExtendedKeyCode()) {
            case 90: {
                this.ctrPlayer.zPressed(false);
                break;
            }
            case 81: {
                this.ctrPlayer.qPressed(false);
                break;
            }
            case 83: {
                this.ctrPlayer.sPressed(false);
                break;
            }
            case 68: {
                this.ctrPlayer.dPressed(false);
                break;
            }
            case 32: {
                this.ctrPlayer.spacePressed(false);
            }
        }
    }

    @Override
    public void onMouseDrag(MouseEvent e) {
    }

    @Override
    public void onMouseMove(MouseEvent e) {
    }

    @Override
    public void onMouseClick(MouseEvent e) {
    }

    @Override
    public void onMousePress(MouseEvent e) {
        switch (e.getButton()) {
            case 1: {
                this.ctrPlayer.lClickPressed(true);
                break;
            }
            case 3: {
                this.ctrPlayer.rClickPressed(true);
            }
        }
    }

    @Override
    public void onMouseRelease(MouseEvent e) {
        switch (e.getButton()) {
            case 1: {
                this.ctrPlayer.lClickPressed(false);
                break;
            }
            case 3: {
                this.ctrPlayer.rClickPressed(false);
            }
        }
    }

    @Override
    public void onMouseEnter(MouseEvent e) {
    }

    @Override
    public void onMouseExit(MouseEvent e) {
    }

    @Override
    public void onAudioEnd(String name) {
    }

    private void playMusic() {
        try {
            this.ctrMain.getAudioManager().playMusic(this.audioStream, 0L, this.ctrMain.getAudioVolume());
        }
        catch (Throwable th) {
            th.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized && this.viewGame.isInitialized() && this.ctrPlayer.isInitialized();
    }
}

