/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.controller;

import com.rymeco.daam.AssetManager;
import com.rymeco.daam.GameConsts;
import com.rymeco.daam.automata.Automata;
import com.rymeco.daam.controller.CtrEndScreen;
import com.rymeco.daam.controller.CtrGame;
import com.rymeco.daam.controller.CtrMenu;
import com.rymeco.daam.controller.IController;
import com.rymeco.daam.model.CylinderMap;
import com.rymeco.daam.model.EnemyAutoStorage;
import com.rymeco.daam.util.audio.AudioManager;
import com.rymeco.daam.util.events.IAudioListener;
import com.rymeco.daam.util.events.ICanvasListener;
import com.rymeco.daam.util.events.IKeyboardListener;
import com.rymeco.daam.util.events.IMouseBtnListener;
import com.rymeco.daam.util.events.IMouseMoveListener;
import com.rymeco.daam.view.GameCanvas;
import com.rymeco.daam.view.ViewMain;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JFrame;

public class CtrMain
implements IController,
IMouseBtnListener,
IMouseMoveListener,
IKeyboardListener,
ICanvasListener,
IAudioListener {
    private BufferedImage tileset;
    public CylinderMap map;
    private ViewMain view;
    private boolean initialized;
    private double cursorX = 0.0;
    private double cursorY = 0.0;
    private GameCanvas canvas;
    private JFrame frame;
    private IController currentController;
    private AudioManager audioManager;
    private EnemyAutoStorage autoStorage;
    private GameConsts.GameState state;
    private boolean validCode;

    public CtrMain() {
        try {
            AssetManager.loadAssets();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        this.audioManager = new AudioManager();
        this.audioManager.setVolume(0.5f);
        this.audioManager.addAudioListener(this);
        this.autoStorage = new EnemyAutoStorage();
        this.setEnemyAutomata(GameConsts.EnemyID.GASTEROLCAN, GameConsts.EnemyID.GASTEROLCAN.toString());
        this.setEnemyAutomata(GameConsts.EnemyID.ZOMBIE, GameConsts.EnemyID.ZOMBIE.toString());
        this.setEnemyAutomata(GameConsts.EnemyID.LAVA_BLOB, GameConsts.EnemyID.LAVA_BLOB.toString());
        this.setEnemyAutomata(GameConsts.EnemyID.TRAMOID, GameConsts.EnemyID.TRAMOID.toString());
        this.setEnemyAutomata(GameConsts.EnemyID.SATAN, GameConsts.EnemyID.SATAN.toString());
        this.setEnemyAutomata(GameConsts.EnemyID.LAVA, GameConsts.EnemyID.LAVA.toString());
        this.setEnemyAutomata(GameConsts.EnemyID.POUF, GameConsts.EnemyID.POUF.toString());
        this.setEnemyAutomata(GameConsts.EnemyID.EXPLOSION, GameConsts.EnemyID.EXPLOSION.toString());
        this.canvas = new GameCanvas();
        Dimension d = new Dimension(1024, 768);
        this.frame = this.canvas.createFrame(d);
        this.canvas.addCanvasListener(this);
        this.canvas.addKeyboardListener(this);
        this.canvas.addMouseMoveListener(this);
        this.canvas.addMouseBtnListener(this);
        this.tileset = AssetManager.getTexture(GameConsts.TexFile.MAIN_TILESET.toString());
        this.view = new ViewMain(this, this.canvas, this.frame);
        this.view.setCursor(this.tileset, 16, 0);
        this.view.resizeSurface();
        this.currentController = new CtrMenu(this);
        this.initialized = true;
    }

    public AudioManager getAudioManager() {
        return this.audioManager;
    }

    public void setAudioVolume(float vol) {
        if (vol < 0.0f) {
            vol = 0.0f;
        }
        if (vol > 1.0f) {
            vol = 1.0f;
        }
        this.audioManager.setVolume(vol);
        this.view.setSliderVolume(vol);
    }

    public float getAudioVolume() {
        return this.audioManager.getVolume();
    }

    public void setEnemyAutomata(GameConsts.EnemyID id, String name) {
        this.autoStorage.setAutomata(id, AssetManager.getGAL(name));
    }

    public Automata getEnemyAutomata(GameConsts.EnemyID id) {
        return this.autoStorage.getAutomata(id);
    }

    public EnemyAutoStorage getAutoStorage() {
        return this.autoStorage;
    }

    public ViewMain getMainView() {
        return this.view;
    }

    public GameConsts.GameState getGameState() {
        return this.state;
    }

    public void validateCode() {
        this.validCode = true;
    }

    public boolean isCodeValid() {
        return this.validCode;
    }

    public void setGameState(GameConsts.GameState state) {
        this.audioManager.stopAll();
        this.state = state;
        switch (state) {
            case GAME: {
                this.currentController = new CtrGame(this);
                break;
            }
            case MENU: {
                this.validCode = false;
                this.currentController = new CtrMenu(this);
                break;
            }
            case END_LOST: {
                this.currentController = new CtrEndScreen(this, true);
                break;
            }
            case END_WON: {
                this.currentController = new CtrEndScreen(this, false);
            }
        }
    }

    public void quit() {
        this.view.getFrame().dispose();
    }

    @Override
    public void onTick(long elapsed) {
        if (this.isInitialized()) {
            this.view.onTick(elapsed);
            this.view.setCursorPos((int)this.cursorX, (int)this.cursorY);
            if (this.currentController.isInitialized()) {
                this.currentController.onTick(elapsed);
            }
        }
    }

    @Override
    public void onWindowOpen() {
        if (this.currentController.isInitialized() && this.currentController instanceof ICanvasListener) {
            ((ICanvasListener)((Object)this.currentController)).onWindowOpen();
        }
    }

    @Override
    public void onWindowClose() {
        if (this.currentController.isInitialized() && this.currentController instanceof ICanvasListener) {
            ((ICanvasListener)((Object)this.currentController)).onWindowClose();
        }
    }

    @Override
    public void onExpired() {
        if (this.currentController.isInitialized() && this.currentController instanceof ICanvasListener) {
            ((ICanvasListener)((Object)this.currentController)).onExpired();
        }
    }

    @Override
    public void onKeyType(KeyEvent e) {
        if (this.currentController.isInitialized() && this.currentController instanceof IKeyboardListener) {
            ((IKeyboardListener)((Object)this.currentController)).onKeyType(e);
        }
    }

    @Override
    public void onKeyPress(KeyEvent e) {
        if (this.currentController.isInitialized() && this.currentController instanceof IKeyboardListener) {
            ((IKeyboardListener)((Object)this.currentController)).onKeyPress(e);
        }
    }

    @Override
    public void onKeyRelease(KeyEvent e) {
        if (this.currentController.isInitialized() && this.currentController instanceof IKeyboardListener) {
            ((IKeyboardListener)((Object)this.currentController)).onKeyRelease(e);
        }
    }

    @Override
    public void onMouseDrag(MouseEvent e) {
        this.cursorX = e.getPoint().getX();
        this.cursorY = e.getPoint().getY();
        this.view.setCursorPos((int)this.cursorX, (int)this.cursorY);
    }

    @Override
    public void onMouseMove(MouseEvent e) {
        this.cursorX = e.getPoint().getX();
        this.cursorY = e.getPoint().getY();
        this.view.setCursorPos((int)this.cursorX, (int)this.cursorY);
    }

    @Override
    public void onMouseClick(MouseEvent e) {
        if (this.currentController.isInitialized() && this.currentController instanceof IMouseBtnListener) {
            ((IMouseBtnListener)((Object)this.currentController)).onMouseClick(e);
        }
    }

    @Override
    public void onMousePress(MouseEvent e) {
        this.view.setCursor(this.tileset, 32, 0);
        if (this.currentController.isInitialized() && this.currentController instanceof IMouseBtnListener) {
            ((IMouseBtnListener)((Object)this.currentController)).onMousePress(e);
        }
    }

    @Override
    public void onMouseRelease(MouseEvent e) {
        this.view.setCursor(this.tileset, 16, 0);
        if (this.currentController.isInitialized() && this.currentController instanceof IMouseBtnListener) {
            ((IMouseBtnListener)((Object)this.currentController)).onMouseRelease(e);
        }
    }

    @Override
    public void onMouseEnter(MouseEvent e) {
    }

    @Override
    public void onMouseExit(MouseEvent e) {
    }

    @Override
    public void onAudioEnd(String name) {
        if (this.currentController.isInitialized() && this.currentController instanceof IAudioListener) {
            ((IAudioListener)((Object)this.currentController)).onAudioEnd(name);
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized && this.view.isInitialized();
    }

    @Override
    public void onWindowResize(ComponentEvent e) {
        this.view.resizeSurface();
    }
}

