/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.controller;

import com.rymeco.daam.AssetManager;
import com.rymeco.daam.GameConsts;
import com.rymeco.daam.controller.CtrMain;
import com.rymeco.daam.controller.IController;
import com.rymeco.daam.util.events.IAudioListener;
import com.rymeco.daam.util.events.IKeyboardListener;
import com.rymeco.daam.util.events.IMouseBtnListener;
import com.rymeco.daam.view.Button;
import com.rymeco.daam.view.ViewMenu;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;

public class CtrMenu
implements IController,
IMouseBtnListener,
IAudioListener,
IKeyboardListener {
    private ViewMenu menu;
    private CtrMain ctrMain;
    private BufferedInputStream audioStream;
    private boolean music = true;
    private boolean initialized;
    private String kcode = "";
    private String dcode = "";
    private String scode = "";

    public CtrMenu(CtrMain ctrMain) {
        this.ctrMain = ctrMain;
        int w = ctrMain.getMainView().getWidth();
        int h = ctrMain.getMainView().getHeight();
        this.menu = new ViewMenu(ctrMain.getMainView().getCursorPos(), w, h);
        this.menu.setCurrentState(GameConsts.MenuState.INTRO);
        ctrMain.getMainView().setView(this.menu);
        this.audioStream = AssetManager.getAudio(GameConsts.AudioFile.TITLE.toString());
        this.playMusic();
        this.initialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public void setGameState(GameConsts.GameState state) {
        this.ctrMain.setGameState(state);
    }

    public void quit() {
        this.ctrMain.quit();
    }

    public ViewMenu getViewMenu() {
        return this.menu;
    }

    public boolean getMusic() {
        return this.music;
    }

    public void setMusic(boolean b) {
        this.music = b;
    }

    @Override
    public void onTick(long elapsed) {
        int n;
        this.menu.onTick(elapsed);
        this.menu.upBgTimer(elapsed);
        if (this.menu.getCurrentState() == GameConsts.MenuState.INTRO) {
            this.menu.upIntroTimer(elapsed);
            if (this.menu.getIntroTimer() > 4800L) {
                this.menu.setCurrentState(GameConsts.MenuState.MAIN);
                this.menu.setIntroTimer(0L);
            }
        }
        if ((n = (int)this.menu.getBgTimer() % 600) < 200) {
            this.menu.getTramoid().setCurrentFrame("anim1");
        } else if (n < 400) {
            this.menu.getTramoid().setCurrentFrame("anim2");
        } else {
            this.menu.getTramoid().setCurrentFrame("anim3");
        }
    }

    @Override
    public void onMouseClick(MouseEvent e) {
        if (this.menu.getCurrentState() == GameConsts.MenuState.INTRO) {
            this.menu.setCurrentState(GameConsts.MenuState.MAIN);
            return;
        }
        int x = (int)this.menu.getCursorX();
        int y = (int)this.menu.getCursorY();
        for (Button b : this.menu.getButtons()) {
            if (!b.isActive()) continue;
            b.press(false);
            if (!b.isInside(x, y)) continue;
            b.effect(this);
        }
    }

    @Override
    public void onMousePress(MouseEvent e) {
        int x = (int)this.menu.getCursorX();
        int y = (int)this.menu.getCursorY();
        for (Button b : this.menu.getButtons()) {
            if (!b.isActive() || !b.isInside(x, y)) continue;
            b.press(true);
        }
    }

    @Override
    public void onMouseRelease(MouseEvent e) {
        for (Button b : this.menu.getButtons()) {
            if (!b.isActive()) continue;
            b.press(false);
        }
    }

    @Override
    public void onMouseEnter(MouseEvent e) {
    }

    @Override
    public void onMouseExit(MouseEvent e) {
    }

    @Override
    public void onAudioEnd(String name) {
    }

    private void playMusic() {
        try {
            this.ctrMain.getAudioManager().playMusic(this.audioStream, 0L, this.ctrMain.getAudioVolume());
        }
        catch (Throwable th) {
            th.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    @Override
    public void onKeyType(KeyEvent e) {
    }

    @Override
    public void onKeyPress(KeyEvent e) {
        if (e.getExtendedKeyCode() == 10) {
            if (this.dcode.equals("djjslmajdldbdjs") || this.kcode.equals("zzssqdqdba")) {
                this.ctrMain.validateCode();
                Toolkit.getDefaultToolkit().beep();
            }
            if (this.scode.equals("showstats")) {
                this.menu.setCurrentState(GameConsts.MenuState.STATS);
                Toolkit.getDefaultToolkit().beep();
            }
        } else {
            this.dcode = String.valueOf(this.dcode) + e.getKeyChar();
            this.kcode = String.valueOf(this.kcode) + e.getKeyChar();
            this.scode = String.valueOf(this.scode) + e.getKeyChar();
            if (this.dcode.length() > 15) {
                this.dcode = this.dcode.substring(1);
            }
            if (this.kcode.length() > 10) {
                this.kcode = this.kcode.substring(1);
            }
            if (this.scode.length() > 9) {
                this.scode = this.scode.substring(1);
            }
        }
    }

    @Override
    public void onKeyRelease(KeyEvent e) {
    }
}

