/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.controller;

import com.rymeco.daam.AssetManager;
import com.rymeco.daam.automata.AutState;
import com.rymeco.daam.automata.Automata;
import com.rymeco.daam.automata.IEntity;
import com.rymeco.daam.controller.CtrBullet;
import com.rymeco.daam.controller.CtrGame;
import com.rymeco.daam.controller.IController;
import com.rymeco.daam.controller.enemies.CtrPouf;
import com.rymeco.daam.controller.items.CtrItem;
import com.rymeco.daam.controller.items.IHealItem;
import com.rymeco.daam.controller.items.IWeaponItem;
import com.rymeco.daam.controller.weapons.CtrWeapon;
import com.rymeco.daam.controller.weapons.CtrWpnGun;
import com.rymeco.daam.controller.weapons.CtrWpnShotgun;
import com.rymeco.daam.model.AbsTiles;
import com.rymeco.daam.model.HitBox;
import com.rymeco.daam.model.Item;
import com.rymeco.daam.model.Player;
import com.rymeco.daam.model.Sprite;
import com.rymeco.daam.model.Weapon;
import com.rymeco.daam.util.Vector2;
import java.awt.image.BufferedImage;

public class CtrPlayer
implements IController,
IEntity {
    private Player player;
    private boolean z;
    private boolean q;
    private boolean s;
    private boolean d;
    private boolean space;
    private boolean lClick;
    private boolean rClick;
    private boolean walkStepAlt;
    private int powerupStep = 21;
    private long imageElapsed;
    private long powerUpImageElapsed;
    private long moveElapsed;
    private boolean initialized;
    private Automata auto;
    private Automata autoBoss;
    private Automata autoLast;
    private AutState currentState;
    private CtrWeapon ctrWpnPrimary;
    private CtrWeapon ctrWpnSecondary;
    private CtrBullet ctrBullet;
    private BufferedImage tileset;
    private int fireAnim;
    private int fireAnimElapsed;
    private int fireCooldown;
    private int fireTick;
    private CtrGame ctrGame;

    public CtrPlayer(BufferedImage tileset, CtrGame ctrGame) {
        this.tileset = tileset;
        this.ctrGame = ctrGame;
        this.player = new Player(tileset);
        this.player.getSprite().setCurrentFrame("idle");
        this.player.getFireAnimSprite().setCurrentFrame("fire1");
        this.ctrBullet = new CtrBullet(tileset, ctrGame);
        ctrGame.getView().getMinimap().setMaxHealth(100);
        ctrGame.getView().getMinimap().setMaxDashTimer(this.player.getMaxDashTimer());
        this.ctrWpnPrimary = new CtrWpnGun(this.ctrBullet, tileset);
        this.ctrWpnSecondary = new CtrWpnShotgun(this.ctrBullet, tileset);
        this.fireAnim = 0;
        this.fireTick = 0;
        this.initialized = true;
    }

    @Override
    public Sprite getSprite() {
        return this.player.getSprite();
    }

    public Sprite getItemAnimSprite() {
        return this.player.getItemAnimSprite();
    }

    public Sprite getFireAnimSprite() {
        return this.player.getFireAnimSprite();
    }

    public CtrBullet getCtrBullet() {
        return this.ctrBullet;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public Weapon getPrimaryWeapon() {
        return this.ctrWpnPrimary.getWeapon();
    }

    public Weapon getSecondaryWeapon() {
        return this.ctrWpnSecondary.getWeapon();
    }

    public void setPrimaryWeapon(CtrWeapon controller) {
        this.ctrWpnPrimary = controller;
    }

    public void setSecondaryyWeapon(CtrWeapon controller) {
        this.ctrWpnSecondary = controller;
    }

    public void setAutomata(Automata auto) {
        this.auto = auto;
        this.autoLast = auto;
    }

    public void setBossAutomata(Automata auto) {
        this.autoBoss = auto;
    }

    public void setBossAutomata(boolean bool) {
        if (bool) {
            this.autoLast = this.auto;
            this.auto = this.autoBoss;
            this.setState(this.auto.getInit());
        } else {
            this.auto = this.autoLast;
            this.setState(this.auto.getInit());
        }
    }

    public void setState(AutState state) {
        this.currentState = state;
    }

    public AutState getCurrentState() {
        return this.currentState;
    }

    public Boolean getOnFire() {
        return this.player.getOnFire();
    }

    public void setOnFire(Boolean onFire) {
        this.player.setOnfire(onFire);
    }

    public Boolean getInLava() {
        return this.player.getInLava();
    }

    public void setInLava(Boolean inLava) {
        this.player.setInLava(inLava);
    }

    public void heal(int health) {
        this.player.heal(health);
    }

    @Override
    public void onTick(long elapsed) {
        this.ctrBullet.onTick(elapsed);
        this.ctrWpnPrimary.onTick(elapsed);
        this.ctrWpnSecondary.onTick(elapsed);
        this.powerUpImageElapsed += elapsed;
        this.fireAnimElapsed = (int)((long)this.fireAnimElapsed + elapsed);
        this.player.dashTimerTick(elapsed);
        this.player.allowHitTimer(elapsed);
        this.ctrGame.getView().getMinimap().setDashTimer(this.player.getDashTimer());
        this.ctrGame.getView().getMinimap().setPlayHealth(this.player.getHealth());
        this.ctrGame.getView().getMinimap().setWeaponSpr(this.getSecondaryWeapon().getSpr());
        this.ctrGame.getView().getMinimap().setAmmoLeft(this.getSecondaryWeapon().getAmmoLeft());
        if (this.player.getDashTimer() >= this.player.getMaxDashTimer()) {
            this.player.allowDash(true);
        }
        if (this.player.getHitTimer() >= this.player.getMaxHitTimer()) {
            this.player.allowHit(true);
            this.player.updateHasKnockBack();
            this.player.getSprite().hide(false);
        }
        if (this.z || this.q || this.s || this.d) {
            this.imageElapsed += elapsed;
            if (this.imageElapsed > 100L) {
                this.imageElapsed = 1L;
                this.player.getSprite().setCurrentFrame(this.walkStepAlt ? "walk2" : "walk1");
                this.walkStepAlt = !this.walkStepAlt;
            }
        } else {
            this.player.getSprite().setCurrentFrame("idle");
        }
        if (this.lClick) {
            this.ctrWpnPrimary.shoot(this);
            if (!this.getPrimaryWeapon().getAuto()) {
                this.lClick = false;
            }
        }
        if (this.rClick) {
            this.ctrWpnSecondary.shoot(this);
            if (!this.getSecondaryWeapon().getAuto()) {
                this.rClick = false;
            }
        }
        if (this.powerUpImageElapsed > 100L) {
            this.powerUpImageElapsed = 1L;
            if (this.powerupStep >= 0 && this.powerupStep <= 20) {
                if (this.powerupStep != 8 && this.powerupStep != 12 && this.powerupStep != 16 && this.powerupStep != 20) {
                    ++this.powerupStep;
                }
                if (this.powerupStep <= 8) {
                    this.player.getItemAnimSprite().setCurrentFrame("heal" + this.powerupStep);
                } else if (this.powerupStep <= 12) {
                    this.player.getItemAnimSprite().setCurrentFrame("weapon_red" + (this.powerupStep - 9));
                } else if (this.powerupStep <= 16) {
                    this.player.getItemAnimSprite().setCurrentFrame("weapon_blue" + (this.powerupStep - 13));
                } else if (this.powerupStep <= 20) {
                    this.player.getItemAnimSprite().setCurrentFrame("weapon_yellow" + (this.powerupStep - 17));
                }
                if (this.powerupStep == 8 || this.powerupStep == 12 || this.powerupStep == 16 || this.powerupStep == 20) {
                    this.powerupStep = 21;
                }
            } else {
                this.player.getItemAnimSprite().setCurrentFrame("void");
            }
        }
        if (this.player.getOnFire().booleanValue()) {
            if (this.fireAnimElapsed > 100) {
                this.fireAnimElapsed = 0;
                ++this.fireTick;
                if (this.fireTick == 2) {
                    this.player.damage(1);
                    this.fireTick = 0;
                }
                switch (this.fireAnim) {
                    case 0: {
                        this.player.getFireAnimSprite().setCurrentFrame("fire1");
                        ++this.fireAnim;
                        break;
                    }
                    case 1: {
                        this.player.getFireAnimSprite().setCurrentFrame("fire2");
                        ++this.fireAnim;
                        break;
                    }
                    case 2: {
                        this.player.getFireAnimSprite().setCurrentFrame("fire3");
                        ++this.fireAnim;
                        break;
                    }
                    case 3: {
                        this.player.getFireAnimSprite().setCurrentFrame("fire4");
                        ++this.fireAnim;
                        break;
                    }
                    case 4: {
                        this.player.getFireAnimSprite().setCurrentFrame("fire5");
                        this.fireAnim = 0;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else {
            this.player.getFireAnimSprite().setCurrentFrame("void");
        }
        this.fireCooldown = this.player.getOnFire() != false ? (int)((long)this.fireCooldown - elapsed) : 3000;
        if (this.fireCooldown <= 0) {
            this.player.setOnfire(false);
        }
        this.moveElapsed += elapsed;
        this.currentState = this.auto.step(this, this.getCurrentState());
        CtrItem item = this.getColItem();
        if (item != null) {
            if (item instanceof IHealItem) {
                ((IHealItem)((Object)item)).heal(this);
                this.powerupStep = 0;
            } else if (item instanceof IWeaponItem) {
                this.powerupStep = ((IWeaponItem)((Object)item)).getWeapon(this, this.tileset, this.ctrBullet);
            }
            item.remove();
        }
        if (!this.player.canTakeHit() && this.player.getHasKnockback()) {
            this.setPlayerPosition(-30.0f, this.player.getDirection());
            this.player.updateHasKnockBack();
        }
        if (!this.player.canTakeHit()) {
            this.player.getSprite().hide(this.player.getHitTimer() / 100L % 2L != 0L);
        }
        if (this.player.getInLava().booleanValue()) {
            this.player.setInLava(false);
        }
    }

    private void setPlayerPosition(float speed, String direction) {
        int dx = 0;
        int dy = 0;
        switch (direction) {
            case "N": {
                dy = -1;
                break;
            }
            case "S": {
                dy = 1;
                break;
            }
            case "W": {
                dx = -1;
                break;
            }
            case "E": {
                dx = 1;
                break;
            }
            case "NW": {
                dx = -1;
                dy = -1;
                break;
            }
            case "NE": {
                dx = 1;
                dy = -1;
                break;
            }
            case "SW": {
                dx = -1;
                dy = 1;
                break;
            }
            case "SE": {
                dx = 1;
                dy = 1;
            }
        }
        this.player.setSpeed(4.0f);
        if (this.player.getInLava().booleanValue()) {
            this.player.setSpeed(1.0f);
        }
        if (this.player.getX() + speed * (float)dx >= (float)this.ctrGame.getMap().getWidth()) {
            this.player.setX(0.0f);
        } else if (this.player.getX() + speed * (float)dx < 0.0f) {
            this.player.setX(this.ctrGame.getMap().getWidth() - 1);
        } else {
            this.player.setX(Math.round(this.player.getX() + speed * (float)dx));
        }
        if (this.player.getY() + speed * (float)dy >= (float)(this.ctrGame.getMap().getHeight() - 16)) {
            this.player.setY(this.ctrGame.getMap().getHeight() - 16);
        } else if (this.player.getY() + speed * (float)dy < 0.0f) {
            this.player.setY(0.0f);
        } else {
            this.player.setY(Math.round(this.player.getY() + speed * (float)dy));
        }
        this.player.getHitBox().setX(this.player.getX() + 3.0f);
        this.player.getHitBox().setY(this.player.getY() + 1.0f);
        this.player.setDirection(direction);
    }

    private boolean simulHitBox(float speed, String direction) {
        int dx = 0;
        int dy = 0;
        switch (direction) {
            case "N": {
                dy = -1;
                break;
            }
            case "S": {
                dy = 1;
                break;
            }
            case "W": {
                dx = -1;
                break;
            }
            case "E": {
                dx = 1;
                break;
            }
            case "NW": {
                dx = -1;
                dy = -1;
                break;
            }
            case "NE": {
                dx = 1;
                dy = -1;
                break;
            }
            case "SW": {
                dx = -1;
                dy = 1;
                break;
            }
            case "SE": {
                dx = 1;
                dy = 1;
            }
        }
        HitBox hit = new HitBox(this.player.getHitBox());
        if (hit.getX() + speed * (float)dx >= (float)this.ctrGame.getMap().getWidth()) {
            hit.setX(0.0f);
        } else if (hit.getX() + speed * (float)dx < 0.0f) {
            hit.setX(this.ctrGame.getMap().getWidth() - 1);
        } else {
            hit.setX(Math.round(hit.getX() + speed * (float)dx));
        }
        if (hit.getY() + speed * (float)dy >= (float)(this.ctrGame.getMap().getHeight() - 16)) {
            hit.setY(this.ctrGame.getMap().getHeight() - 16);
        } else if (this.player.getY() + speed * (float)dy < 0.0f) {
            hit.setY(0.0f);
        } else {
            hit.setY(Math.round(hit.getY() + speed * (float)dy));
        }
        return this.tileColi(hit);
    }

    private boolean tileColi(HitBox hit) {
        int x = (int)hit.getX();
        int y = (int)hit.getY();
        HitBox hit2 = null;
        if ((float)x + hit.getWidth() >= (float)this.ctrGame.getMap().getWidth()) {
            hit2 = new HitBox(x - this.ctrGame.getMap().getWidth(), y, hit.getWidth(), hit.getHeight());
        }
        AbsTiles tile1 = this.ctrGame.getMap().getTiles()[Math.floorMod(y /= 16, this.ctrGame.getMap().getTileHeight())][Math.floorMod(x /= 16, this.ctrGame.getMap().getTileWidth())];
        AbsTiles tile2 = this.ctrGame.getMap().getTiles()[Math.floorMod(y, this.ctrGame.getMap().getTileHeight())][Math.floorMod(x + 1, this.ctrGame.getMap().getTileWidth())];
        AbsTiles tile3 = this.ctrGame.getMap().getTiles()[Math.floorMod(y + 1, this.ctrGame.getMap().getTileHeight())][Math.floorMod(x, this.ctrGame.getMap().getTileWidth())];
        AbsTiles tile4 = this.ctrGame.getMap().getTiles()[Math.floorMod(y + 1, this.ctrGame.getMap().getTileHeight())][Math.floorMod(x + 1, this.ctrGame.getMap().getTileWidth())];
        return tile1 != null && hit.collide(tile1.getHitBox()) && !tile1.isWalkableThrough() || tile2 != null && hit.collide(tile2.getHitBox()) && !tile2.isWalkableThrough() || tile3 != null && hit.collide(tile3.getHitBox()) && !tile3.isWalkableThrough() || tile4 != null && hit.collide(tile4.getHitBox()) && !tile4.isWalkableThrough() || hit2 != null && (tile1 != null && hit2.collide(tile1.getHitBox()) && !tile1.isWalkableThrough() || tile2 != null && hit2.collide(tile2.getHitBox()) && !tile2.isWalkableThrough() || tile3 != null && hit2.collide(tile3.getHitBox()) && !tile3.isWalkableThrough() || tile4 != null && hit2.collide(tile4.getHitBox()) && !tile4.isWalkableThrough());
    }

    public CtrItem getColItem() {
        for (CtrItem c : this.ctrGame.getItems()) {
            Item i = c.getItem();
            if (!this.player.getHitBox().collide(i.getHitBox())) continue;
            return c;
        }
        return null;
    }

    public void shootPrimary() {
        this.ctrWpnPrimary.shoot(this);
    }

    public void shootSecondary() {
        this.ctrWpnSecondary.shoot(this);
    }

    @Override
    public void pop(String direction) {
        if (this.moveElapsed > 24L) {
            this.moveElapsed = 0L;
            float currentSpeed = this.player.getSpeed();
            if (direction.equals("NE") || direction.equals("NW") || direction.equals("SE") || direction.equals("SW")) {
                currentSpeed /= 1.4f;
            }
            if (this.player.canDash()) {
                this.player.allowDash(false);
                currentSpeed *= 13.0f;
                this.player.resetDashTimer();
                if (direction.equals("H")) {
                    direction = this.player.getDirection();
                }
                this.setPlayerPosition(currentSpeed, direction);
                BufferedImage tileset = AssetManager.getTexture("spritesheet");
                CtrPouf c = new CtrPouf(tileset, this.ctrGame);
                this.ctrGame.createEnemy(c, this.player.getX(), this.player.getY());
            }
        }
        if (!this.player.canDash() && !this.cell(direction, "O")) {
            this.move(direction);
        }
    }

    @Override
    public void move(String direction) {
        if (direction.equals("F")) {
            direction = this.player.getDirection();
        }
        float speed = this.player.getSpeed();
        if (direction.equals("NE") || direction.equals("NW") || direction.equals("SE") || direction.equals("SW")) {
            speed /= 1.4f;
        }
        if ((float)this.moveElapsed > 24.0f / speed) {
            this.moveElapsed = 0L;
            this.setPlayerPosition(1.0f, direction);
        }
    }

    public void zPressed(boolean pressed) {
        this.z = pressed;
    }

    public void qPressed(boolean pressed) {
        this.q = pressed;
    }

    public void sPressed(boolean pressed) {
        this.s = pressed;
    }

    public void dPressed(boolean pressed) {
        this.d = pressed;
    }

    public void spacePressed(boolean pressed) {
        this.space = pressed;
    }

    public void lClickPressed(boolean pressed) {
        this.lClick = pressed;
    }

    public void rClickPressed(boolean pressed) {
        this.rClick = pressed;
    }

    @Override
    public Vector2 getPosition() {
        return this.player.getPosition();
    }

    public void setPosition(Vector2 pos) {
        this.player.setPosition(pos);
    }

    @Override
    public HitBox getHitBox() {
        return this.player.getHitBox();
    }

    @Override
    public boolean key(String key) {
        switch (key) {
            case "z": {
                return this.z;
            }
            case "q": {
                return this.q;
            }
            case "s": {
                return this.s;
            }
            case "d": {
                return this.d;
            }
            case "SPACE": {
                return this.space;
            }
        }
        return false;
    }

    @Override
    public boolean myDir(String dir) {
        return false;
    }

    @Override
    public boolean cell(String direction, String category) {
        String string = category;
        string.hashCode();
        return this.simulHitBox(1.0f, direction);
    }

    @Override
    public boolean closest(String direction, String category) {
        return false;
    }

    @Override
    public boolean gotPower() {
        return this.player.getHealth() > 0;
    }

    @Override
    public boolean gotStuff() {
        return false;
    }

    @Override
    public void wizz(String direction) {
    }

    @Override
    public void pause() {
    }

    @Override
    public void jump(String direction) {
    }

    @Override
    public void turn(String direction) {
    }

    @Override
    public void hit(String direction) {
    }

    @Override
    public void protect(String direction) {
    }

    @Override
    public void pick(String direction) {
    }

    @Override
    public void drop(String direction) {
    }

    @Override
    public void store() {
    }

    @Override
    public void get() {
    }

    @Override
    public void power() {
    }

    @Override
    public void explode() {
    }

    @Override
    public void egg(String category) {
    }

    @Override
    public void damage(int damage) {
        this.player.damage(damage);
    }

    @Override
    public boolean canTakeHit() {
        return this.player.canTakeHit();
    }

    @Override
    public void allowHit(boolean hitlag) {
        this.player.allowHit(hitlag);
    }

    @Override
    public void resetHitTimer() {
        this.player.resetHitTimer();
    }
}

