/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.controller;

import com.rymeco.daam.controller.IController;
import com.rymeco.daam.model.AbsTiles;
import com.rymeco.daam.model.CylinderMap;
import com.rymeco.daam.model.Ground;
import com.rymeco.daam.model.Rock;
import com.rymeco.daam.util.Vector2;
import java.awt.image.BufferedImage;

public class CtrTiles
implements IController {
    private BufferedImage tileset;
    private boolean initialized;
    CylinderMap map;

    public CtrTiles(BufferedImage tileset, CylinderMap map) {
        this.tileset = tileset;
        this.map = map;
        this.initialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void onTick(long elapsed) {
    }

    public AbsTiles spawnTile(Vector2 position, int id) {
        AbsTiles tile;
        int x = (int)position.x;
        int y = (int)position.y;
        switch (id) {
            default: {
                tile = new Ground(x * 16, y * 16, this.tileset);
                break;
            }
            case 1: {
                tile = new Rock(x * 16, y * 16, this.tileset);
            }
        }
        this.map.setTile(x, y, tile);
        return tile;
    }

    public AbsTiles spawnTile(int x, int y, int id) {
        return this.spawnTile(new Vector2(x, y), id);
    }

    public AbsTiles[][] getTiles() {
        return this.map.getTiles();
    }
}

