/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.controller;

import com.rymeco.daam.GameConsts;
import com.rymeco.daam.controller.CtrGame;
import com.rymeco.daam.controller.IController;
import com.rymeco.daam.controller.enemies.CtrEnemy;
import com.rymeco.daam.controller.enemies.CtrGasterolcan;
import com.rymeco.daam.controller.enemies.CtrLavaBlob;
import com.rymeco.daam.controller.enemies.CtrSatanClaus;
import com.rymeco.daam.controller.enemies.CtrTramoid;
import com.rymeco.daam.controller.enemies.CtrZombie;
import com.rymeco.daam.model.Wave;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class CtrWave
implements IController {
    private boolean initialized = true;
    private CtrGame ctrGame;
    private HashMap<GameConsts.EnemyID, Integer> counters = new HashMap();

    public CtrWave(CtrGame ctrGame) {
        this.ctrGame = ctrGame;
    }

    public boolean hasNextWave() {
        return this.ctrGame.getMap().getWaves().size() > 0;
    }

    public boolean waveEnded() {
        int count = 0;
        for (int c : this.counters.values()) {
            count += c;
        }
        return count == 0;
    }

    public void removeEnemy(GameConsts.EnemyID id) {
        int count;
        if (this.counters.containsKey((Object)id) && (count = this.counters.get((Object)id).intValue()) > 0) {
            this.counters.put(id, count - 1);
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void onTick(long elapsed) {
    }

    public void loadNextWave(BufferedImage tileset) {
        this.counters.clear();
        Wave w = this.ctrGame.getMap().getWaves().poll();
        if (w != null) {
            for (Wave.EnemyStruct e : w.getEnemies()) {
                CtrEnemy c = null;
                switch (e.id) {
                    case GASTEROLCAN: {
                        c = new CtrGasterolcan(tileset, this.ctrGame);
                        break;
                    }
                    case LAVA_BLOB: {
                        c = new CtrLavaBlob(tileset, this.ctrGame);
                        break;
                    }
                    case SATAN: {
                        c = new CtrSatanClaus(tileset, this.ctrGame);
                        break;
                    }
                    case TRAMOID: {
                        c = new CtrTramoid(tileset, this.ctrGame);
                        break;
                    }
                    case ZOMBIE: {
                        c = new CtrZombie(tileset, this.ctrGame);
                        break;
                    }
                }
                if (c == null) continue;
                if (!this.counters.containsKey((Object)e.id)) {
                    this.counters.put(e.id, 1);
                } else {
                    int count = this.counters.get((Object)e.id);
                    this.counters.put(e.id, count + 1);
                }
                this.ctrGame.createEnemy(c, e.x * 16, e.y * 16);
            }
        }
    }
}

