/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.controller.enemies;

import com.rymeco.daam.GameConsts;
import com.rymeco.daam.automata.AutState;
import com.rymeco.daam.automata.Automata;
import com.rymeco.daam.automata.IEntity;
import com.rymeco.daam.controller.CtrGame;
import com.rymeco.daam.controller.IController;
import com.rymeco.daam.model.AbsTiles;
import com.rymeco.daam.model.CylinderMap;
import com.rymeco.daam.model.HitBox;
import com.rymeco.daam.model.Sprite;
import com.rymeco.daam.model.enemies.AbsEnemy;
import com.rymeco.daam.model.enemies.SatanClaus;
import com.rymeco.daam.util.Vector2;

public abstract class CtrEnemy
implements IController,
IEntity {
    protected AutState currentState;
    protected AbsEnemy enemy;
    protected CtrGame ctrGame;
    private long moveLag;
    private long pauseTimer;
    protected long hideTimer = 0L;

    public CtrEnemy(AbsEnemy enemy, CtrGame ctrGame) {
        this.enemy = enemy;
        this.ctrGame = ctrGame;
    }

    public GameConsts.EnemyID getEnemyID() {
        return this.enemy.getID();
    }

    public String getDirection() {
        return this.enemy.getDirection();
    }

    public void setDirection(String direction) {
        this.enemy.setDirection(direction);
    }

    public IEntity getTarget() {
        return this.enemy.getTarget();
    }

    public void setTarget(IEntity target) {
        this.enemy.setTarget(target);
    }

    public float getRange() {
        return this.enemy.getRange();
    }

    public void setPosition(Vector2 position) {
        this.enemy.setPosition(position);
    }

    @Override
    public Vector2 getPosition() {
        return this.enemy.getPosition();
    }

    public float getX() {
        return this.enemy.getX();
    }

    public float getY() {
        return this.enemy.getY();
    }

    @Override
    public void damage(int damage) {
        this.enemy.damage(damage);
    }

    public int getHealth() {
        return this.enemy.getHealth();
    }

    public void setHealth(int health) {
        this.enemy.setHealth(health);
    }

    @Override
    public Sprite getSprite() {
        return this.enemy.getSprite();
    }

    public Automata getAutomata() {
        Automata a = this.ctrGame.getAutoStorage().getAutomata(this.enemy.getID());
        if (!a.getStates().contains(this.currentState)) {
            this.currentState = a.getInit();
        }
        return a;
    }

    public long getMoveLag() {
        return this.moveLag;
    }

    public void setMoveLag(long lag) {
        this.moveLag = lag;
    }

    public long getPauseTimer() {
        return this.pauseTimer;
    }

    public void setPauseTimer(long timer) {
        this.pauseTimer = timer;
    }

    public void setState(AutState state) {
        this.currentState = state;
    }

    public AutState getCurrentState() {
        return this.currentState;
    }

    @Override
    public HitBox getHitBox() {
        return this.enemy.getHitBox();
    }

    public CylinderMap getMap() {
        return this.ctrGame.getMap();
    }

    protected boolean targetInCone(String direction, Vector2 position) {
        Vector2 u;
        IEntity target = this.getTarget();
        if (target == null) {
            return false;
        }
        switch (direction) {
            case "N": {
                u = new Vector2(0.0f, -1.0f);
                break;
            }
            case "S": {
                u = new Vector2(0.0f, 1.0f);
                break;
            }
            case "E": {
                u = new Vector2(1.0f, 0.0f);
                break;
            }
            case "W": {
                u = new Vector2(-1.0f, 0.0f);
                break;
            }
            case "NE": {
                u = new Vector2(1.0f, -1.0f);
                break;
            }
            case "NW": {
                u = new Vector2(-1.0f, -1.0f);
                break;
            }
            case "SE": {
                u = new Vector2(1.0f, 1.0f);
                break;
            }
            case "SW": {
                u = new Vector2(-1.0f, 1.0f);
                break;
            }
            case "H": {
                return this.enemyColi(target);
            }
            default: {
                return false;
            }
        }
        Vector2 sourcePos = this.getPosition();
        Vector2 v = new Vector2(position.x - sourcePos.x, position.y - sourcePos.y);
        return Vector2.angleBetween(u, v) <= 22.5 && this.inRange(position);
    }

    protected boolean inRange(Vector2 position) {
        Vector2 pos = this.getPosition();
        return pos.distanceTo(position) <= (double)this.getRange();
    }

    protected void moveEnemy(float speed, String direction) {
        int dx = 0;
        int dy = 0;
        switch (direction) {
            case "N": {
                dy = -1;
                break;
            }
            case "S": {
                dy = 1;
                break;
            }
            case "W": {
                dx = -1;
                break;
            }
            case "E": {
                dx = 1;
                break;
            }
            case "NW": {
                dx = -1;
                dy = -1;
                speed /= 1.4f;
                break;
            }
            case "NE": {
                dx = 1;
                dy = -1;
                speed /= 1.4f;
                break;
            }
            case "SW": {
                dx = -1;
                dy = 1;
                speed /= 1.4f;
                break;
            }
            case "SE": {
                dx = 1;
                dy = 1;
                speed /= 1.4f;
            }
        }
        if (this.enemy.getX() + speed * (float)dx > (float)this.ctrGame.getMap().getWidth()) {
            this.enemy.setX(0.0f);
        } else if (this.enemy.getX() + speed * (float)dx < 0.0f) {
            this.enemy.setX(this.ctrGame.getMap().getWidth() - 1);
        } else {
            this.enemy.setX(Math.round(this.enemy.getX() + speed * (float)dx));
        }
        if (this.enemy.getY() + speed * (float)dy >= (float)(this.ctrGame.getMap().getHeight() - 16)) {
            this.enemy.setY(this.ctrGame.getMap().getHeight() - 16);
        } else if (this.enemy.getY() + speed * (float)dy < 0.0f) {
            this.enemy.setY(0.0f);
        } else {
            this.enemy.setY(Math.round(this.enemy.getY() + speed * (float)dy));
        }
        this.enemy.setDirection(direction);
    }

    @Override
    public boolean closest(String direction, String category) {
        if (this.getTarget() == null) {
            return false;
        }
        Vector2 pos1 = this.getTarget().getPosition();
        Vector2 pos2 = new Vector2(pos1);
        Vector2 pos3 = new Vector2(pos1);
        pos2.x -= (float)this.getMap().getWidth();
        pos3.x += (float)this.getMap().getWidth();
        Vector2 min = pos1;
        if (this.getPosition().distanceTo(pos2) < this.getPosition().distanceTo(min)) {
            min = pos2;
        }
        if (this.getPosition().distanceTo(pos3) < this.getPosition().distanceTo(min)) {
            min = pos3;
        }
        return this.targetInCone(direction, min);
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean cell(String direction, String category) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[4] lbl22 : CaseStatement: default:\u000a, @NONE, blocks:[4] lbl22 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public void turn(String direction) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[13] lbl177 : CaseStatement: default:\u000a, @NONE, blocks:[13] lbl177 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean enemyColi(IEntity target) {
        HitBox hit = this.enemy.getHitBox();
        HitBox hit2 = null;
        if (hit.getX() + hit.getWidth() >= (float)this.ctrGame.getMap().getWidth()) {
            hit2 = new HitBox(hit.getX() - (float)this.ctrGame.getMap().getWidth(), hit.getY(), hit.getWidth(), hit.getHeight());
        }
        HitBox hitTarget = target.getHitBox();
        HitBox hitTarget2 = null;
        if (hitTarget.getX() + hitTarget.getWidth() >= (float)this.ctrGame.getMap().getWidth()) {
            hitTarget2 = new HitBox(hitTarget.getX() - (float)this.ctrGame.getMap().getWidth(), hitTarget.getY(), hitTarget.getWidth(), hitTarget.getHeight());
        }
        return hit.collide(hitTarget) || hitTarget2 != null && hit.collide(hitTarget2) || hit2 != null && hit2.collide(hitTarget) || hit2 != null && hitTarget2 != null && hit2.collide(hitTarget2);
    }

    private boolean simulHitBox(float speed, String direction) {
        int dx = 0;
        int dy = 0;
        switch (direction) {
            case "N": {
                dy = -1;
                break;
            }
            case "S": {
                dy = 1;
                break;
            }
            case "W": {
                dx = -1;
                break;
            }
            case "E": {
                dx = 1;
                break;
            }
            case "NW": {
                dx = -1;
                dy = -1;
                break;
            }
            case "NE": {
                dx = 1;
                dy = -1;
                break;
            }
            case "SW": {
                dx = -1;
                dy = 1;
                break;
            }
            case "SE": {
                dx = 1;
                dy = 1;
            }
        }
        HitBox hit = new HitBox(this.enemy.getHitBox());
        if (hit.getX() + speed * (float)dx > (float)this.ctrGame.getMap().getWidth()) {
            hit.setX(0.0f);
        } else if (this.enemy.getX() + speed * (float)dx < 0.0f) {
            hit.setX(this.ctrGame.getMap().getWidth() - 1);
        } else {
            hit.setX(Math.round(hit.getX() + speed * (float)dx));
        }
        if (hit.getY() + speed * (float)dy >= (float)(this.ctrGame.getMap().getHeight() - 16)) {
            hit.setY(this.ctrGame.getMap().getHeight() - 16);
        } else if (this.enemy.getY() + speed * (float)dy < 0.0f) {
            hit.setY(0.0f);
        } else {
            hit.setY(Math.round(hit.getY() + speed * (float)dy));
        }
        return this.tileColi(hit);
    }

    private boolean tileColi(HitBox hit) {
        int x = (int)hit.getX();
        int y = (int)hit.getY();
        x /= 16;
        y /= 16;
        AbsTiles[][] tiles = this.ctrGame.getMap().getTiles();
        if (!(this.enemy instanceof SatanClaus)) {
            AbsTiles tile1 = tiles[Math.floorMod(y, this.ctrGame.getMap().getTileHeight())][Math.floorMod(x, this.ctrGame.getMap().getTileWidth())];
            AbsTiles tile2 = tiles[Math.floorMod(y, this.ctrGame.getMap().getTileHeight())][Math.floorMod(x + 1, this.ctrGame.getMap().getTileWidth())];
            AbsTiles tile3 = tiles[Math.floorMod(y + 1, this.ctrGame.getMap().getTileHeight())][Math.floorMod(x, this.ctrGame.getMap().getTileWidth())];
            AbsTiles tile4 = tiles[Math.floorMod(y + 1, this.ctrGame.getMap().getTileHeight())][Math.floorMod(x + 1, this.ctrGame.getMap().getTileWidth())];
            return tile1 != null && hit.collide(tile1.getHitBox()) && !tile1.isWalkableThrough() || tile2 != null && hit.collide(tile2.getHitBox()) && !tile2.isWalkableThrough() || tile3 != null && hit.collide(tile3.getHitBox()) && !tile3.isWalkableThrough() || tile4 != null && hit.collide(tile4.getHitBox()) && !tile4.isWalkableThrough();
        }
        AbsTiles tile1 = tiles[Math.floorMod(y, this.ctrGame.getMap().getTileHeight())][Math.floorMod(x, this.ctrGame.getMap().getTileWidth())];
        AbsTiles tile2 = tiles[Math.floorMod(y, this.ctrGame.getMap().getTileHeight())][Math.floorMod(x + 1, this.ctrGame.getMap().getTileWidth())];
        AbsTiles tile3 = tiles[Math.floorMod(y, this.ctrGame.getMap().getTileHeight())][Math.floorMod(x + 2, this.ctrGame.getMap().getTileWidth())];
        AbsTiles tile4 = tiles[Math.floorMod(y + 1, this.ctrGame.getMap().getTileHeight())][Math.floorMod(x, this.ctrGame.getMap().getTileWidth())];
        AbsTiles tile5 = tiles[Math.floorMod(y + 1, this.ctrGame.getMap().getTileHeight())][Math.floorMod(x + 1, this.ctrGame.getMap().getTileWidth())];
        AbsTiles tile6 = tiles[Math.floorMod(y + 1, this.ctrGame.getMap().getTileHeight())][Math.floorMod(x + 2, this.ctrGame.getMap().getTileWidth())];
        AbsTiles tile7 = tiles[Math.floorMod(y + 2, this.ctrGame.getMap().getTileHeight())][Math.floorMod(x, this.ctrGame.getMap().getTileWidth())];
        AbsTiles tile8 = tiles[Math.floorMod(y + 2, this.ctrGame.getMap().getTileHeight())][Math.floorMod(x + 1, this.ctrGame.getMap().getTileWidth())];
        AbsTiles tile9 = tiles[Math.floorMod(y + 2, this.ctrGame.getMap().getTileHeight())][Math.floorMod(x + 2, this.ctrGame.getMap().getTileWidth())];
        return tile1 != null && hit.collide(tile1.getHitBox()) && !tile1.isWalkableThrough() || tile2 != null && hit.collide(tile2.getHitBox()) && !tile2.isWalkableThrough() || tile3 != null && hit.collide(tile3.getHitBox()) && !tile3.isWalkableThrough() || tile4 != null && hit.collide(tile4.getHitBox()) && !tile4.isWalkableThrough() || tile5 != null && hit.collide(tile5.getHitBox()) && !tile5.isWalkableThrough() || tile6 != null && hit.collide(tile6.getHitBox()) && !tile6.isWalkableThrough() || tile7 != null && hit.collide(tile7.getHitBox()) && !tile7.isWalkableThrough() || tile8 != null && hit.collide(tile8.getHitBox()) && !tile8.isWalkableThrough() || tile9 != null && hit.collide(tile9.getHitBox()) && !tile9.isWalkableThrough();
    }

    public void setHideTimer(long l) {
        if (this.hideTimer > 200L) {
            this.hideTimer = l;
        }
    }

    @Override
    public boolean canTakeHit() {
        return false;
    }

    @Override
    public void allowHit(boolean hitlag) {
    }

    @Override
    public void resetHitTimer() {
    }
}

