/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.controller.enemies;

import com.rymeco.daam.AssetManager;
import com.rymeco.daam.GameConsts;
import com.rymeco.daam.controller.CtrGame;
import com.rymeco.daam.controller.enemies.CtrEnemy;
import com.rymeco.daam.controller.enemies.CtrLava;
import com.rymeco.daam.controller.enemies.CtrPouf;
import com.rymeco.daam.model.enemies.Gasterolcan;
import com.rymeco.daam.util.Vector2;
import java.awt.image.BufferedImage;

public class CtrGasterolcan
extends CtrEnemy {
    private int anim = 0;
    private long imageElapsed;
    private long moveElapsed;
    private boolean initialized;
    private BufferedImage tileset;
    private Vector2 lastLavaPos;

    public CtrGasterolcan(BufferedImage tileset, CtrGame ctrGame) {
        super(new Gasterolcan(tileset), ctrGame);
        this.enemy.getSprite().setCurrentFrame("anim1");
        this.ctrGame = ctrGame;
        this.tileset = tileset;
        this.lastLavaPos = new Vector2(0.0f, 0.0f);
        this.initialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void onTick(long elapsed) {
        this.imageElapsed += elapsed;
        this.moveElapsed += elapsed;
        this.hideTimer += elapsed;
        this.setMoveLag(this.getMoveLag() + elapsed);
        this.setPauseTimer(this.getPauseTimer() + elapsed);
        if (this.hideTimer > 100L) {
            this.getSprite().hide(false);
        }
        if (this.imageElapsed > 500L) {
            this.imageElapsed = 1L;
            String dir = this.enemy.getDirection();
            if (dir.equals("N") || dir.equals("NW") || dir.equals("NE")) {
                switch (this.anim) {
                    case 0: {
                        this.enemy.getSprite().setCurrentFrame("anim4");
                        ++this.anim;
                        break;
                    }
                    case 1: {
                        this.enemy.getSprite().setCurrentFrame("anim5");
                        ++this.anim;
                        break;
                    }
                    case 2: {
                        this.enemy.getSprite().setCurrentFrame("anim6");
                        this.anim = 0;
                    }
                }
            } else {
                switch (this.anim) {
                    case 0: {
                        this.enemy.getSprite().setCurrentFrame("anim1");
                        ++this.anim;
                        break;
                    }
                    case 1: {
                        this.enemy.getSprite().setCurrentFrame("anim2");
                        ++this.anim;
                        break;
                    }
                    case 2: {
                        this.enemy.getSprite().setCurrentFrame("anim3");
                        this.anim = 0;
                    }
                }
            }
        }
        if (this.getAutomata() != null && this.moveElapsed > 24L) {
            this.currentState = this.getAutomata().step(this, this.getCurrentState());
        }
    }

    @Override
    public boolean key(String key) {
        return false;
    }

    @Override
    public boolean myDir(String direction) {
        return false;
    }

    @Override
    public boolean gotPower() {
        return this.enemy.getHealth() > 0;
    }

    @Override
    public boolean gotStuff() {
        return false;
    }

    @Override
    public void wizz(String direction) {
        int x = (int)this.getPosition().x;
        int y = (int)this.getPosition().y;
        GameConsts.ItemID type = GameConsts.ItemID.HEAL;
        switch (direction) {
            case "N": {
                type = GameConsts.ItemID.CHICKEN;
                break;
            }
            case "S": {
                type = GameConsts.ItemID.HEAL;
                break;
            }
            case "E": {
                type = GameConsts.ItemID.AMMO_RAILGUN;
                break;
            }
            case "W": {
                type = GameConsts.ItemID.AMMO_SHOTGUN;
                break;
            }
            case "NE": {
                type = GameConsts.ItemID.AMMO_ROCKET;
            }
        }
        this.ctrGame.createItem(x, y, type, true, 5000);
    }

    @Override
    public void pop(String direction) {
        BufferedImage tileset = AssetManager.getTexture("spritesheet");
        CtrPouf c = new CtrPouf(tileset, this.ctrGame);
        this.ctrGame.createEnemy(c, this.getX(), this.getY());
    }

    @Override
    public void pause() {
        if (this.getPauseTimer() > 2000L) {
            this.setPauseTimer(0L);
        }
    }

    @Override
    public void move(String direction) {
        if (direction.equals("F")) {
            direction = this.enemy.getDirection();
        }
        if (this.moveElapsed > 24L) {
            this.moveElapsed = 0L;
            if (this.getPauseTimer() < 2000L && this.getMoveLag() > 500L) {
                return;
            }
            this.moveEnemy(this.enemy.getSpeed(), this.enemy.getDirection());
            if (this.getMoveLag() > 500L) {
                this.setMoveLag(0L);
                this.moveEnemy(this.enemy.getSpeed(), direction);
            }
            this.egg("");
            this.enemy.getHitBox().setX(this.enemy.getX() + 2.0f);
            this.enemy.getHitBox().setY(this.enemy.getY() + 4.0f);
        }
    }

    @Override
    public void jump(String direction) {
    }

    @Override
    public void turn(String direction) {
    }

    @Override
    public void hit(String direction) {
        if (this.enemy.getTarget().canTakeHit()) {
            this.enemy.getTarget().damage(this.enemy.getDamage());
            this.enemy.getTarget().allowHit(false);
            this.enemy.getTarget().resetHitTimer();
        }
    }

    @Override
    public void protect(String direction) {
    }

    @Override
    public void pick(String direction) {
    }

    @Override
    public void drop(String direction) {
    }

    @Override
    public void store() {
    }

    @Override
    public void get() {
    }

    @Override
    public void power() {
    }

    @Override
    public void explode() {
    }

    @Override
    public void egg(String category) {
        if (Math.abs(this.getPosition().x - this.lastLavaPos.x) > 16.0f || Math.abs(this.getPosition().y - this.lastLavaPos.y) > 16.0f) {
            int x = (int)(this.getPosition().x + 8.0f) / 16 * 16;
            int y = (int)(this.getPosition().y + 8.0f) / 16 * 16;
            CtrLava c = new CtrLava(x, y, this.tileset, this.ctrGame, 3000);
            c.setTarget(this.getTarget());
            this.ctrGame.createEnemy(c, x, y);
            this.lastLavaPos = new Vector2(this.getPosition());
        }
    }
}

