/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.controller.enemies;

import com.rymeco.daam.controller.CtrGame;
import com.rymeco.daam.controller.CtrPlayer;
import com.rymeco.daam.controller.enemies.CtrEnemy;
import com.rymeco.daam.model.enemies.Lava;
import com.rymeco.daam.util.Vector2;
import java.awt.image.BufferedImage;

public class CtrLava
extends CtrEnemy {
    private int anim = 0;
    private long imageElapsed;
    private long moveElapsed;
    private long moveLag;
    private long pauseTimer;
    private boolean initialized;

    public CtrLava(Vector2 position, BufferedImage tileset, CtrGame ctrGame, int lifeTime) {
        super(new Lava(position, tileset, lifeTime), ctrGame);
        this.enemy.getSprite().setAllowFlip(false);
        this.enemy.getSprite().setCurrentFrame("anim1");
        this.setPosition(position);
        this.initialized = true;
    }

    public CtrLava(float x, float y, BufferedImage tileset, CtrGame ctrGame, int lifeTime) {
        this(new Vector2(x, y), tileset, ctrGame, lifeTime);
    }

    public CtrLava(BufferedImage tileset, CtrGame ctrGame, int lifeTime) {
        this(new Vector2(), tileset, ctrGame, lifeTime);
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void onTick(long elapsed) {
        this.imageElapsed += elapsed;
        this.moveElapsed += elapsed;
        this.moveLag += elapsed;
        this.pauseTimer += elapsed;
        Lava lava = (Lava)this.enemy;
        lava.reduceLifeTime(elapsed);
        if (lava.getLifeTime() == 0L) {
            lava.setHealth(0);
        }
        if (this.imageElapsed > 400L) {
            this.imageElapsed = 1L;
            switch (this.anim) {
                case 0: {
                    this.enemy.getSprite().setCurrentFrame("anim1");
                    ++this.anim;
                    break;
                }
                case 1: {
                    this.enemy.getSprite().setCurrentFrame("anim2");
                    ++this.anim;
                    break;
                }
                case 2: {
                    this.enemy.getSprite().setCurrentFrame("anim3");
                    ++this.anim;
                    break;
                }
                case 3: {
                    this.enemy.getSprite().setCurrentFrame("anim4");
                    this.anim = 0;
                }
            }
        }
        if (this.getAutomata() != null && this.moveElapsed > 24L) {
            this.currentState = this.getAutomata().step(this, this.getCurrentState());
        }
    }

    @Override
    public boolean key(String key) {
        return false;
    }

    @Override
    public boolean myDir(String direction) {
        return false;
    }

    @Override
    public boolean cell(String direction, String category) {
        return false;
    }

    @Override
    public boolean gotPower() {
        return this.enemy.getHealth() > 0;
    }

    @Override
    public boolean gotStuff() {
        return false;
    }

    @Override
    public void wizz(String direction) {
    }

    @Override
    public void pop(String direction) {
    }

    @Override
    public void pause() {
        if (this.pauseTimer > 2000L) {
            this.pauseTimer = 0L;
        }
    }

    @Override
    public void move(String direction) {
        if (this.moveElapsed > 24L) {
            this.moveElapsed = 0L;
            if (this.pauseTimer < 2000L && this.moveLag > 500L) {
                return;
            }
            this.moveEnemy(this.enemy.getSpeed(), this.enemy.getDirection());
            if (this.moveLag > 500L) {
                this.moveLag = 0L;
                this.moveEnemy(this.enemy.getSpeed(), direction);
            }
            this.enemy.getHitBox().setX(this.enemy.getX() + 2.0f);
            this.enemy.getHitBox().setY(this.enemy.getY() + 4.0f);
        }
    }

    @Override
    public void jump(String direction) {
    }

    @Override
    public void turn(String direction) {
    }

    @Override
    public void hit(String direction) {
        CtrPlayer target = (CtrPlayer)this.enemy.getTarget();
        target.setOnFire(true);
        target.setInLava(true);
    }

    @Override
    public void protect(String direction) {
    }

    @Override
    public void pick(String direction) {
    }

    @Override
    public void drop(String direction) {
    }

    @Override
    public void store() {
    }

    @Override
    public void get() {
    }

    @Override
    public void power() {
    }

    @Override
    public void explode() {
    }

    @Override
    public void egg(String category) {
    }
}

