/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.controller.enemies;

import com.rymeco.daam.AssetManager;
import com.rymeco.daam.automata.IEntity;
import com.rymeco.daam.controller.CtrBullet;
import com.rymeco.daam.controller.CtrGame;
import com.rymeco.daam.controller.CtrPlayer;
import com.rymeco.daam.controller.enemies.CtrEnemy;
import com.rymeco.daam.controller.enemies.CtrPouf;
import com.rymeco.daam.controller.weapons.CtrWeapon;
import com.rymeco.daam.controller.weapons.CtrWpnBossGun;
import com.rymeco.daam.controller.weapons.CtrWpnExplosionBossGun;
import com.rymeco.daam.model.Weapon;
import com.rymeco.daam.model.enemies.SatanClaus;
import com.rymeco.daam.util.Vector2;
import java.awt.image.BufferedImage;

public class CtrSatanClaus
extends CtrEnemy {
    private long moveElapsed;
    private long explodeElapsed;
    private long changeAutoElapsed;
    private long moveLag;
    private long pauseTimer;
    private boolean initialized;
    private boolean walk = true;
    private boolean isExploding = false;
    private boolean canExplode = false;
    private boolean isChangingAuto = false;
    private boolean canChangeAuto = false;
    private CtrWeapon ctrWpnPrimary;
    private CtrWeapon ctrWpnGun;
    private CtrWeapon ctrWpnExplosion;
    private CtrBullet ctrBullet;

    public CtrSatanClaus(BufferedImage tileset, CtrGame ctrGame) {
        super(new SatanClaus(tileset), ctrGame);
        this.enemy.getSprite().setCurrentFrame("satan1");
        this.ctrBullet = new CtrBullet(tileset, ctrGame);
        this.ctrBullet.setCtrPlayer(ctrGame.getPlayer());
        this.ctrWpnPrimary = this.ctrWpnGun = new CtrWpnBossGun(this.ctrBullet, tileset);
        this.ctrWpnExplosion = new CtrWpnExplosionBossGun(this.ctrBullet, tileset);
        this.initialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public CtrBullet getCtrBullet() {
        return this.ctrBullet;
    }

    public Weapon getPrimaryWeapon() {
        return this.ctrWpnPrimary.getWeapon();
    }

    public void setPrimaryWeapon(CtrWeapon controller) {
        this.ctrWpnPrimary = controller;
    }

    @Override
    public void onTick(long elapsed) {
        this.moveElapsed += elapsed;
        this.hideTimer += elapsed;
        if (!this.canExplode) {
            this.explodeElapsed += elapsed;
        }
        if (!this.canChangeAuto) {
            this.changeAutoElapsed += elapsed;
        }
        this.moveLag += elapsed;
        this.pauseTimer += elapsed;
        this.ctrBullet.onTick(elapsed);
        this.ctrWpnPrimary.onTick(elapsed);
        if (this.hideTimer > 100L) {
            this.getSprite().hide(false);
        }
        if (this.explodeElapsed > 2000L) {
            if (this.explodeElapsed > 10000L) {
                this.canExplode = true;
                this.explodeElapsed = 0L;
            }
            this.isExploding = false;
            this.ctrWpnPrimary = this.ctrWpnGun;
        }
        if (this.changeAutoElapsed > 2000L) {
            if (this.changeAutoElapsed > 20000L) {
                this.canChangeAuto = true;
                this.changeAutoElapsed = 0L;
            }
            this.isChangingAuto = false;
            if (this.getTarget() != null && this.getTarget() instanceof CtrPlayer) {
                CtrPlayer p = (CtrPlayer)this.getTarget();
                p.setBossAutomata(false);
            }
        }
        if (this.getAutomata() != null && this.moveElapsed > 24L) {
            this.currentState = this.getAutomata().step(this, this.getCurrentState());
        }
    }

    @Override
    public boolean key(String key) {
        return false;
    }

    @Override
    public boolean myDir(String direction) {
        return false;
    }

    @Override
    public boolean cell(String direction, String category) {
        return false;
    }

    @Override
    public boolean gotPower() {
        return this.enemy.getHealth() > 0;
    }

    @Override
    public boolean gotStuff() {
        return false;
    }

    @Override
    public void wizz(String direction) {
        if (this.canChangeAuto && !this.isExploding) {
            this.canChangeAuto = false;
            this.isChangingAuto = true;
            this.enemy.getSprite().setCurrentFrame("satan2");
            if (this.getTarget() != null && this.getTarget() instanceof CtrPlayer) {
                CtrPlayer p = (CtrPlayer)this.getTarget();
                p.setBossAutomata(true);
            }
            this.enemy.getSprite().setCurrentFrame("satan2");
        }
    }

    @Override
    public void pop(String direction) {
        if (this.canExplode && !this.isChangingAuto) {
            this.canExplode = false;
            this.isExploding = true;
            this.ctrWpnPrimary = this.ctrWpnExplosion;
            this.enemy.getSprite().setCurrentFrame("satan3");
        }
    }

    @Override
    public void pause() {
        this.enemy.getSprite().setCurrentFrame("satan1");
        if (this.pauseTimer > 2000L) {
            this.pauseTimer = 0L;
        }
    }

    @Override
    public void move(String direction) {
        if (this.moveElapsed > 24L) {
            this.moveElapsed = 0L;
            if (this.pauseTimer < 2000L && this.moveLag > 500L || this.isExploding || this.isChangingAuto) {
                return;
            }
            this.moveEnemy(this.enemy.getSpeed(), this.enemy.getDirection());
            if (this.moveLag > 500L) {
                this.moveLag = 0L;
                this.moveEnemy(this.enemy.getSpeed(), direction);
                this.enemy.getSprite().setCurrentFrame(this.walk ? "satan4" : "satan5");
                this.walk = !this.walk;
            }
            this.enemy.getHitBox().setX(this.enemy.getX() + 4.0f);
            this.enemy.getHitBox().setY(this.enemy.getY() + 7.0f);
        }
    }

    @Override
    public void jump(String direction) {
    }

    @Override
    public void turn(String direction) {
    }

    @Override
    public void hit(String direction) {
        this.ctrWpnPrimary.shoot(this);
    }

    @Override
    public void protect(String direction) {
    }

    @Override
    public void pick(String direction) {
    }

    @Override
    public void drop(String direction) {
    }

    @Override
    public void store() {
    }

    @Override
    public void get() {
    }

    @Override
    public void power() {
    }

    @Override
    public void explode() {
    }

    @Override
    public void egg(String category) {
        BufferedImage tileset = AssetManager.getTexture("spritesheet");
        CtrPouf c = new CtrPouf(tileset, this.ctrGame);
        this.ctrGame.createEnemy(c, this.getX(), this.getY());
    }

    @Override
    protected boolean targetInCone(String direction, Vector2 position) {
        Vector2 u;
        IEntity target = this.getTarget();
        if (target == null) {
            return false;
        }
        switch (direction) {
            case "N": {
                u = new Vector2(0.0f, -1.0f);
                break;
            }
            case "S": {
                u = new Vector2(0.0f, 1.0f);
                break;
            }
            case "E": {
                u = new Vector2(1.0f, 0.0f);
                break;
            }
            case "W": {
                u = new Vector2(-1.0f, 0.0f);
                break;
            }
            case "NE": {
                u = new Vector2(1.0f, -1.0f);
                break;
            }
            case "NW": {
                u = new Vector2(-1.0f, -1.0f);
                break;
            }
            case "SE": {
                u = new Vector2(1.0f, 1.0f);
                break;
            }
            case "SW": {
                u = new Vector2(-1.0f, 1.0f);
                break;
            }
            case "H": {
                return this.getPosition().distanceTo(target.getPosition()) <= 100.0;
            }
            default: {
                return false;
            }
        }
        Vector2 sourcePos = this.getPosition();
        Vector2 v = new Vector2(position.x - sourcePos.x, position.y - sourcePos.y);
        return Vector2.angleBetween(u, v) <= 22.5 && this.inRange(position);
    }
}

