/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.controller.enemies;

import com.rymeco.daam.AssetManager;
import com.rymeco.daam.controller.CtrGame;
import com.rymeco.daam.controller.enemies.CtrEnemy;
import com.rymeco.daam.controller.enemies.CtrPouf;
import com.rymeco.daam.model.enemies.Tramoid;
import com.rymeco.daam.util.Vector2;
import java.awt.image.BufferedImage;

public class CtrTramoid
extends CtrEnemy {
    private int anim = 0;
    private long imageElapsed;
    private long moveElapsed;
    private long hitTimer = 0L;
    private boolean initialized;

    public CtrTramoid(BufferedImage tileset, CtrGame ctrGame) {
        super(new Tramoid(tileset), ctrGame);
        this.enemy.getSprite().setCurrentFrame("anim1");
        this.ctrGame = ctrGame;
        this.initialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void onTick(long elapsed) {
        this.imageElapsed += elapsed;
        this.moveElapsed += elapsed;
        this.hitTimer += elapsed;
        this.hideTimer += elapsed;
        this.setMoveLag(this.getMoveLag() + elapsed);
        this.setPauseTimer(this.getPauseTimer() + elapsed);
        if (this.hideTimer > 100L) {
            this.getSprite().hide(false);
        }
        if (((Tramoid)this.enemy).getLeech()) {
            Vector2 pos = new Vector2(this.enemy.getTarget().getPosition().x, this.enemy.getTarget().getPosition().y - 8.0f);
            this.setPosition(pos);
            this.enemy.getHitBox().setPosition(pos);
        }
        if (this.imageElapsed > 200L) {
            this.imageElapsed = 1L;
            switch (this.anim) {
                case 0: {
                    this.enemy.getSprite().setCurrentFrame("anim1");
                    ++this.anim;
                    break;
                }
                case 1: {
                    this.enemy.getSprite().setCurrentFrame("anim2");
                    ++this.anim;
                    break;
                }
                case 2: {
                    this.enemy.getSprite().setCurrentFrame("anim3");
                    this.anim = 0;
                }
            }
        }
        if (this.getAutomata() != null && this.moveElapsed > 24L) {
            this.currentState = this.getAutomata().step(this, this.getCurrentState());
        }
    }

    @Override
    public boolean key(String key) {
        return false;
    }

    @Override
    public boolean myDir(String direction) {
        return false;
    }

    @Override
    public boolean gotPower() {
        return this.enemy.getHealth() > 0;
    }

    @Override
    public boolean gotStuff() {
        return false;
    }

    @Override
    public void wizz(String direction) {
    }

    @Override
    public void pop(String direction) {
        BufferedImage tileset = AssetManager.getTexture("spritesheet");
        CtrPouf c = new CtrPouf(tileset, this.ctrGame);
        this.ctrGame.createEnemy(c, this.getX(), this.getY());
    }

    @Override
    public void pause() {
        if (this.getPauseTimer() > 2000L) {
            this.setPauseTimer(0L);
        }
    }

    @Override
    public void move(String direction) {
        if (!((Tramoid)this.enemy).getLeech()) {
            if (direction.equals("F")) {
                direction = this.enemy.getDirection();
            }
            if (this.moveElapsed > 24L) {
                this.moveElapsed = 0L;
                if (this.getPauseTimer() < 2000L && this.getMoveLag() > 500L) {
                    return;
                }
                this.moveEnemy(this.enemy.getSpeed(), this.enemy.getDirection());
                if (this.getMoveLag() > 500L) {
                    this.setMoveLag(0L);
                    this.moveEnemy(this.enemy.getSpeed(), direction);
                }
                this.enemy.getHitBox().setX(this.enemy.getX() + 2.0f);
                this.enemy.getHitBox().setY(this.enemy.getY() + 2.0f);
            }
        }
    }

    @Override
    public void jump(String direction) {
    }

    @Override
    public void turn(String direction) {
    }

    @Override
    public void hit(String direction) {
        if (this.enemy.getTarget().canTakeHit()) {
            ((Tramoid)this.enemy).setLeech(true);
            if (this.hitTimer > 1000L) {
                this.enemy.getTarget().damage(this.enemy.getDamage());
                this.hitTimer = 0L;
            }
        }
    }

    @Override
    public void protect(String direction) {
    }

    @Override
    public void pick(String direction) {
    }

    @Override
    public void drop(String direction) {
    }

    @Override
    public void store() {
    }

    @Override
    public void get() {
    }

    @Override
    public void power() {
    }

    @Override
    public void explode() {
    }

    @Override
    public void egg(String category) {
    }
}

