/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.controller.enemies;

import com.rymeco.daam.AssetManager;
import com.rymeco.daam.GameConsts;
import com.rymeco.daam.automata.IEntity;
import com.rymeco.daam.controller.CtrGame;
import com.rymeco.daam.controller.enemies.CtrEnemy;
import com.rymeco.daam.controller.enemies.CtrPouf;
import com.rymeco.daam.model.Sprite;
import com.rymeco.daam.model.enemies.Zombie;
import com.rymeco.daam.util.Vector2;
import java.awt.image.BufferedImage;

public class CtrZombie
extends CtrEnemy {
    private long moveElapsed;
    private boolean initialized;
    private boolean walk = true;
    private CtrGame ctrGame;

    public CtrZombie(BufferedImage tileset, CtrGame ctrGame) {
        super(new Zombie(tileset), ctrGame);
        this.ctrGame = ctrGame;
        this.enemy.getSprite().setCurrentFrame("anim1");
        this.initialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public Sprite getSprite() {
        return this.enemy.getSprite();
    }

    @Override
    public Vector2 getPosition() {
        return this.enemy.getPosition();
    }

    @Override
    public void setPosition(Vector2 position) {
        this.enemy.setPosition(position);
    }

    @Override
    public void setTarget(IEntity target) {
        this.enemy.setTarget(target);
    }

    @Override
    public IEntity getTarget() {
        return this.enemy.getTarget();
    }

    @Override
    public float getRange() {
        return this.enemy.getRange();
    }

    @Override
    public void onTick(long elapsed) {
        this.moveElapsed += elapsed;
        this.hideTimer += elapsed;
        this.setMoveLag(this.getMoveLag() + elapsed);
        this.setPauseTimer(this.getPauseTimer() + elapsed);
        if (this.hideTimer > 100L) {
            this.getSprite().hide(false);
        }
        if (this.getAutomata() != null && this.moveElapsed > 24L) {
            this.currentState = this.getAutomata().step(this, this.getCurrentState());
        }
    }

    @Override
    public boolean key(String key) {
        return false;
    }

    @Override
    public boolean myDir(String direction) {
        return false;
    }

    @Override
    public boolean gotPower() {
        return this.enemy.getHealth() > 0;
    }

    @Override
    public boolean gotStuff() {
        return false;
    }

    @Override
    public void wizz(String direction) {
    }

    @Override
    public void pop(String direction) {
        BufferedImage tileset = AssetManager.getTexture("spritesheet");
        CtrPouf c = new CtrPouf(tileset, this.ctrGame);
        this.ctrGame.createEnemy(c, this.getX(), this.getY());
    }

    @Override
    public void pause() {
        if (this.getPauseTimer() > 2000L) {
            this.setPauseTimer(0L);
        }
    }

    @Override
    public void move(String direction) {
        if (direction.equals("F")) {
            direction = this.enemy.getDirection();
        }
        if (this.moveElapsed > 24L) {
            this.moveElapsed = 0L;
            if (this.getPauseTimer() < 2000L && this.getMoveLag() > 500L) {
                return;
            }
            this.moveEnemy(this.enemy.getSpeed(), this.enemy.getDirection());
            if (this.getMoveLag() > 500L) {
                this.setMoveLag(0L);
                this.moveEnemy(this.enemy.getSpeed(), direction);
                this.enemy.getSprite().setCurrentFrame(this.walk ? "anim2" : "anim1");
                this.walk = !this.walk;
            }
            this.enemy.getHitBox().setX(this.enemy.getX() + 3.0f);
            this.enemy.getHitBox().setY(this.enemy.getY() + 1.0f);
        }
    }

    @Override
    public void jump(String direction) {
    }

    @Override
    public void hit(String direction) {
        if (this.enemy.getTarget().canTakeHit()) {
            this.enemy.getTarget().damage(this.enemy.getDamage());
            this.enemy.getTarget().allowHit(false);
            this.enemy.getTarget().resetHitTimer();
        }
    }

    @Override
    public void protect(String direction) {
    }

    @Override
    public void pick(String direction) {
    }

    @Override
    public void drop(String direction) {
    }

    @Override
    public void store() {
    }

    @Override
    public void get() {
    }

    @Override
    public void power() {
    }

    @Override
    public void explode() {
    }

    @Override
    public void egg(String category) {
        int x = (int)this.getPosition().x;
        int y = (int)this.getPosition().y;
        GameConsts.ItemID type = GameConsts.ItemID.HEAL;
        switch (category) {
            case "J": {
                type = GameConsts.ItemID.CHICKEN;
                break;
            }
            case "T": {
                type = GameConsts.ItemID.HEAL;
                break;
            }
            case "A": {
                type = GameConsts.ItemID.AMMO_RAILGUN;
                break;
            }
            case "P": {
                type = GameConsts.ItemID.AMMO_SHOTGUN;
                break;
            }
            case "C": {
                type = GameConsts.ItemID.AMMO_ROCKET;
            }
        }
        this.ctrGame.createItem(x, y, type, true, 5000);
    }
}

