/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.controller.items;

import com.rymeco.daam.controller.IController;
import com.rymeco.daam.model.Item;
import com.rymeco.daam.model.Sprite;
import com.rymeco.daam.util.Vector2;

public abstract class CtrItem
implements IController {
    protected Item item;
    protected boolean initialized;

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public Sprite getSprite() {
        return this.item.getSprite();
    }

    public abstract Sprite getSecondarySprite();

    public void setPosition(Vector2 pos) {
        this.setPosition(pos.x, pos.y);
    }

    public void setPosition(float x, float y) {
        this.item.setX(x);
        this.item.setY(y);
        if (this.getSecondarySprite() != null) {
            this.getSecondarySprite().setX(x);
            this.getSecondarySprite().setY(y);
        }
    }

    public Vector2 getPosition() {
        return this.item.getPosition();
    }

    public void setInitialized(boolean init) {
        this.initialized = init;
    }

    public Item getItem() {
        return this.item;
    }

    public void setItem(Item i) {
        this.item = i;
    }

    public boolean mustRemove() {
        return this.item.getLifeTime() < 0;
    }

    public void remove() {
        this.item.setLifeTime(-1);
    }

    @Override
    public void onTick(long elapsed) {
    }
}

