/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.controller.weapons;

import com.rymeco.daam.automata.IEntity;
import com.rymeco.daam.controller.CtrBullet;
import com.rymeco.daam.controller.IController;
import com.rymeco.daam.model.Weapon;
import java.awt.image.BufferedImage;

public abstract class CtrWeapon
implements IController {
    protected Weapon weapon;
    protected CtrBullet ctrBullet;
    protected long elapsed;
    protected boolean initialized;

    public CtrWeapon(CtrBullet ctrBullet, BufferedImage tileset, String name, int ammo, float rof, float damage, float range, boolean auto) {
        this.weapon = new Weapon(name, tileset, ammo, rof, damage, range, auto);
        this.ctrBullet = ctrBullet;
    }

    public void shoot(IEntity source) {
        if ((float)this.elapsed > this.getWeapon().getRof() && (this.weapon.getAmmoLeft() == -1 || this.weapon.getAmmoLeft() > 0)) {
            this.ctrBullet.bulletSpawn(source, 0.0f, this.getWeapon());
            this.elapsed = 0L;
            if (this.weapon.getAmmoLeft() != -1) {
                this.weapon.setAmmoLeft(this.weapon.getAmmoLeft() - 1);
            }
        }
    }

    public void reload() {
        this.weapon.setAmmoLeft(this.weapon.getAmmo());
    }

    public Weapon getWeapon() {
        return this.weapon;
    }

    public static Weapon defaultWeapon(BufferedImage tileset) {
        return new Weapon("gun", tileset, -1, 1000.0f, 20.0f, 128.0f, false);
    }

    @Override
    public void onTick(long elapsed) {
        this.elapsed += elapsed;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }
}

