/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.model;

import com.rymeco.daam.model.AbsEntity;
import com.rymeco.daam.model.HitBox;
import com.rymeco.daam.model.Sprite;
import com.rymeco.daam.model.Weapon;
import com.rymeco.daam.util.Vector2;
import java.awt.image.BufferedImage;

public class Bullet
extends AbsEntity {
    private Vector2 direction;
    private Vector2 startPos;
    private int elapsed;
    private Weapon weapon;

    public Bullet(Vector2 position, Vector2 direction, BufferedImage texture, Weapon weapon) {
        this.sprite = new Sprite((int)position.x, (int)position.y, texture);
        this.position = new Vector2(position);
        this.startPos = new Vector2(position);
        this.direction = new Vector2(direction);
        this.sprite.addFrame("gun", 96, 0);
        this.sprite.addFrame("railgun", 112, 0);
        this.sprite.addFrame("shotgun", 128, 0);
        this.sprite.addFrame("rocketlauncher", 144, 0);
        this.sprite.addFrame("bossgun", 160, 0);
        this.sprite.addFrame("explosionbossgun", 160, 0);
        this.sprite.setCurrentFrame(weapon.getName());
        this.weapon = weapon;
        HitBox hitbox = new HitBox(position, 4.0f, 4.0f);
        this.setHitBox(hitbox);
        this.elapsed = 0;
    }

    @Override
    public Vector2 getPosition() {
        return new Vector2(this.position);
    }

    @Override
    public float getX() {
        return this.position.x;
    }

    @Override
    public float getY() {
        return this.position.y;
    }

    @Override
    public void setPosition(Vector2 position) {
        this.setPosition(position.x, position.y);
    }

    @Override
    public void setPosition(float x, float y) {
        this.setX(x);
        this.setY(y);
    }

    public void setStartPosition(Vector2 position) {
        this.setStartPosition(position.x, position.y);
    }

    public void setStartPosition(float x, float y) {
        this.startPos.x = x;
        this.startPos.y = y;
    }

    @Override
    public void setX(float x) {
        this.position.x = x;
        this.sprite.setX((int)x);
    }

    @Override
    public void setY(float y) {
        this.position.y = y;
        this.sprite.setY((int)y);
    }

    public void translate() {
        this.elapsed += 9;
        this.position.translate(this.direction.multiply(6.0f));
        this.sprite.setX((int)this.position.x);
        this.sprite.setY((int)this.position.y);
    }

    public Vector2 getDirection() {
        return this.direction;
    }

    public void setDirection(Vector2 direction) {
        this.setDirection(direction.x, direction.y);
    }

    public void setDirection(float x, float y) {
        this.direction.x = x;
        this.direction.y = y;
    }

    @Override
    public Sprite getSprite() {
        return this.sprite;
    }

    public int getElapsed() {
        return this.elapsed;
    }

    public Weapon getWeapon() {
        return this.weapon;
    }
}

