/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.model;

import com.rymeco.daam.controller.CtrTeleporter;
import com.rymeco.daam.controller.enemies.CtrEnemy;
import com.rymeco.daam.controller.items.CtrItem;
import com.rymeco.daam.model.AbsTiles;
import com.rymeco.daam.model.Wave;
import com.rymeco.daam.util.Vector2;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;

public class CylinderMap {
    private int tileWidth;
    private int tileHeight;
    private Vector2 spawn;
    private AbsTiles[][] tiles;
    private ArrayList<CtrEnemy> enemies;
    private ArrayList<CtrItem> items;
    private ArrayList<CtrTeleporter> teleporters;
    private Queue<Wave> waves;

    public CylinderMap(int w, int h) {
        this.tileWidth = w;
        this.tileHeight = h;
        this.spawn = new Vector2(0.0f, 0.0f);
        this.enemies = new ArrayList();
        this.items = new ArrayList();
        this.teleporters = new ArrayList();
        this.tiles = new AbsTiles[h][w];
        this.waves = new LinkedList<Wave>();
    }

    public void setSpawn(Vector2 spawn) {
        this.spawn = spawn;
    }

    public Vector2 getSpawn() {
        return this.spawn;
    }

    public void setTeleporters(ArrayList<CtrTeleporter> teleporters) {
        this.teleporters = teleporters;
    }

    public ArrayList<CtrTeleporter> getTeleporters() {
        return this.teleporters;
    }

    public void addTeleporter(CtrTeleporter teleporter) {
        this.teleporters.add(teleporter);
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getWidth() {
        return this.tileWidth * 16;
    }

    public int getHeight() {
        return this.tileHeight * 16;
    }

    public AbsTiles[][] getTiles() {
        return this.tiles;
    }

    public void setTile(int x, int y, AbsTiles tile) {
        this.tiles[y][x] = tile;
    }

    public ArrayList<CtrEnemy> getEnemies() {
        return this.enemies;
    }

    public void addEnemy(CtrEnemy e) {
        this.enemies.add(e);
    }

    public void removeEnemy(CtrEnemy e) {
        this.enemies.remove(e);
    }

    public ArrayList<CtrItem> getItems() {
        return this.items;
    }

    public void addItem(CtrItem i) {
        this.items.add(i);
    }

    public void removeItem(CtrItem i) {
        this.items.remove(i);
    }

    public void addWave(Wave wave) {
        this.waves.add(wave);
    }

    public Queue<Wave> getWaves() {
        return this.waves;
    }
}

