/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.model;

import com.rymeco.daam.util.Vector2;

public class HitBox {
    private Vector2 position;
    private float width;
    private float height;

    public HitBox(Vector2 position, float width, float height) {
        this.position = new Vector2(position);
        this.width = width;
        this.height = height;
    }

    public HitBox(float x, float y, float width, float height) {
        this(new Vector2(x, y), width, height);
    }

    public HitBox(HitBox box) {
        this(box.getPosition(), box.getWidth(), box.getHeight());
    }

    public Vector2 getPosition() {
        return this.position;
    }

    public float getX() {
        return this.position.x;
    }

    public float getY() {
        return this.position.y;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setPosition(Vector2 pos) {
        this.position = new Vector2(pos);
    }

    public void setPosition(float x, float y) {
        this.setPosition(new Vector2(x, y));
    }

    public void setX(float x) {
        this.position.x = x;
    }

    public void setY(float y) {
        this.position.y = y;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public boolean collide(HitBox box) {
        if (box == null) {
            return false;
        }
        float x1 = this.getX();
        float x2 = box.getX();
        float y1 = this.getY();
        float y2 = box.getY();
        float w1 = this.getWidth();
        float w2 = box.getWidth();
        float h1 = this.getHeight();
        float h2 = box.getHeight();
        return (x1 >= x2 && x1 <= x2 + w2 || x2 >= x1 && x2 <= x1 + w1) && (y1 >= y2 && y1 <= y2 + h2 || y2 >= y1 && y2 <= y1 + h1);
    }
}

