/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.model;

import com.rymeco.daam.model.AbsEntity;
import com.rymeco.daam.model.HitBox;
import com.rymeco.daam.model.Sprite;
import com.rymeco.daam.util.Vector2;
import java.awt.image.BufferedImage;

public class Item
extends AbsEntity {
    private int lifeTime;
    private boolean despawn = false;

    public Item(Vector2 position, BufferedImage texture) {
        this.sprite = new Sprite(position, texture);
        this.position = new Vector2(position);
        HitBox hit = new HitBox(this.getX() + 2.0f, this.getY() + 2.0f, 12.0f, 12.0f);
        this.setHitBox(hit);
    }

    public Item(float x, float y, BufferedImage texture) {
        this(new Vector2(x, y), texture);
    }

    public Item(BufferedImage texture) {
        this(0.0f, 0.0f, texture);
    }

    public int getLifeTime() {
        return this.lifeTime;
    }

    public void setLifeTime(int lifeTime) {
        this.lifeTime = lifeTime;
    }

    public void setDespawn(boolean bool) {
        this.despawn = bool;
    }

    public boolean getDespawn() {
        return this.despawn;
    }

    @Override
    public Vector2 getPosition() {
        return this.position;
    }

    @Override
    public float getX() {
        return this.position.x;
    }

    @Override
    public float getY() {
        return this.position.y;
    }

    @Override
    public void setPosition(Vector2 position) {
        this.setPosition(position.x, position.y);
    }

    @Override
    public void setPosition(float x, float y) {
        this.setX(x);
        this.setY(y);
    }

    @Override
    public void setX(float x) {
        this.position.x = x;
        this.sprite.setX(x);
        this.hitbox.setX(x);
    }

    @Override
    public void setY(float y) {
        this.position.y = y;
        this.sprite.setY(y);
        this.hitbox.setY(y);
    }

    @Override
    public Sprite getSprite() {
        return this.sprite;
    }
}

