/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.model;

import com.rymeco.daam.model.AbsEntity;
import com.rymeco.daam.model.HitBox;
import com.rymeco.daam.model.Sprite;
import com.rymeco.daam.model.Weapon;
import com.rymeco.daam.util.Vector2;
import java.awt.image.BufferedImage;

public class Player
extends AbsEntity {
    private Sprite itemAnimSprite;
    private Sprite fireSprite;
    private float speed;
    private int maxHealth = 100;
    private int health = 100;
    private long dashTimer;
    private long maxDashTimer = 2000L;
    private boolean canDash;
    private String direction;
    private Weapon weapon;
    private boolean canTakeHit;
    private long hitTimer;
    private long maxHitTimer = 1000L;
    private boolean hasKnockback;
    private boolean onFire;
    private boolean inLava;

    public Player(Vector2 position, BufferedImage texture) {
        this.sprite = new Sprite(position, texture);
        this.itemAnimSprite = new Sprite(position, texture);
        this.fireSprite = new Sprite(position, texture);
        this.position = new Vector2(position);
        this.sprite.addFrame("idle", 48, 0);
        this.sprite.addFrame("walk1", 64, 0);
        this.sprite.addFrame("walk2", 80, 0);
        this.sprite.setPriority(10);
        this.itemAnimSprite.addFrame("void", 176, 80);
        this.itemAnimSprite.setCurrentFrame("void");
        int i = 0;
        while (i < 9) {
            this.itemAnimSprite.addFrame("heal" + i, 32 + 16 * i, 80);
            ++i;
        }
        i = 0;
        while (i < 4) {
            this.itemAnimSprite.addFrame("weapon_red" + i, 16 + 16 * i, 96);
            this.itemAnimSprite.addFrame("weapon_blue" + i, 16 + 16 * i + 64, 96);
            this.itemAnimSprite.addFrame("weapon_yellow" + i, 16 + 16 * i + 128, 96);
            ++i;
        }
        this.fireSprite.addFrame("void", 176, 80);
        this.fireSprite.addFrame("fire1", 96, 64);
        this.fireSprite.addFrame("fire2", 112, 64);
        this.fireSprite.addFrame("fire3", 128, 64);
        this.fireSprite.addFrame("fire4", 144, 64);
        this.fireSprite.addFrame("fire5", 160, 64);
        this.canDash = true;
        this.canTakeHit = true;
        this.hasKnockback = true;
        this.direction = "N";
        this.speed = 4.0f;
        HitBox hitbox = new HitBox(position.x + 3.0f, position.y + 1.0f, 10.0f, 15.0f);
        this.setHitBox(hitbox);
        this.onFire = false;
        this.inLava = false;
    }

    public Player(int x, int y, BufferedImage texture) {
        this(new Vector2(x, y), texture);
    }

    public Player(BufferedImage texture) {
        this(0, 0, texture);
    }

    @Override
    public Vector2 getPosition() {
        return this.position;
    }

    @Override
    public float getX() {
        return this.position.x;
    }

    @Override
    public float getY() {
        return this.position.y;
    }

    @Override
    public void setPosition(Vector2 position) {
        this.setPosition(position.x, position.y);
    }

    @Override
    public void setPosition(float x, float y) {
        this.setX(x);
        this.setY(y);
    }

    @Override
    public void setX(float x) {
        this.position.x = x;
        this.sprite.setX(x);
        this.itemAnimSprite.setX(x);
        this.fireSprite.setX(x);
    }

    @Override
    public void setY(float y) {
        this.position.y = y;
        this.sprite.setY(y);
        this.itemAnimSprite.setY(y);
        this.fireSprite.setY(y + 1.0f);
    }

    @Override
    public Sprite getSprite() {
        return this.sprite;
    }

    public Sprite getItemAnimSprite() {
        return this.itemAnimSprite;
    }

    public Sprite getFireAnimSprite() {
        return this.fireSprite;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getSpeed() {
        return this.speed;
    }

    public boolean canDash() {
        return this.canDash;
    }

    public void allowDash(boolean allow) {
        this.canDash = allow;
    }

    public void dashTimerTick(long elapsed) {
        this.dashTimer += elapsed;
    }

    public void resetDashTimer() {
        this.dashTimer = 0L;
    }

    public long getDashTimer() {
        return this.dashTimer;
    }

    public long getMaxDashTimer() {
        return this.maxDashTimer;
    }

    public boolean canTakeHit() {
        return this.canTakeHit;
    }

    public void allowHit(boolean hitlag) {
        this.canTakeHit = hitlag;
    }

    public void allowHitTimer(long elapsed) {
        this.hitTimer += elapsed;
    }

    public void resetHitTimer() {
        this.hitTimer = 0L;
    }

    public long getHitTimer() {
        return this.hitTimer;
    }

    public long getMaxHitTimer() {
        return this.maxHitTimer;
    }

    public void setDirection(String dir) {
        if (!(dir.equals("N") || dir.equals("S") || dir.equals("W") || dir.equals("E") || dir.equals("NW") || dir.equals("NE") || dir.equals("SW") || dir.equals("SE"))) {
            dir = "N";
        }
        this.direction = dir;
    }

    public String getDirection() {
        return this.direction;
    }

    public int getHealth() {
        return this.health;
    }

    public void setHealth(int health) {
        if (health > this.maxHealth) {
            health = this.maxHealth;
        } else if (health < 0) {
            health = 0;
        }
        this.health = health;
    }

    public void heal(int health) {
        this.health += health;
        if (this.health > this.maxHealth) {
            this.health = this.maxHealth;
        }
    }

    public void damage(int damage) {
        this.health = damage > this.getHealth() ? 0 : (this.health -= damage);
    }

    public void kill() {
        this.health = 0;
    }

    public Weapon getWeapon() {
        return this.weapon;
    }

    public void setWeapon(Weapon weapon) {
        this.weapon = weapon;
    }

    public boolean getHasKnockback() {
        return this.hasKnockback;
    }

    public void updateHasKnockBack() {
        this.hasKnockback = !this.hasKnockback;
    }

    public Boolean getOnFire() {
        return this.onFire;
    }

    public void setOnfire(Boolean onFire) {
        this.onFire = onFire;
    }

    public Boolean getInLava() {
        return this.inLava;
    }

    public void setInLava(Boolean inLava) {
        this.inLava = inLava;
    }
}

