/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.model;

import com.rymeco.daam.util.Vector2;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class Sprite
implements Comparable<Sprite> {
    private Vector2 position;
    private HashMap<String, Vector2> frames;
    private BufferedImage texture;
    private String currentFrame;
    private String direction;
    private int priority;
    private boolean flipH;
    private boolean allowFlip = true;
    private int w = 16;
    private int h = 16;
    private boolean hide;

    public Sprite(float x, float y, BufferedImage texture) {
        this.position = new Vector2(x, y);
        this.texture = texture;
        this.frames = new HashMap();
        this.frames.put("default", new Vector2(0.0f, 0.0f));
        this.currentFrame = "default";
        this.hide = false;
    }

    public void setSize32(boolean bool) {
        if (bool) {
            this.w = 32;
            this.h = 32;
        } else {
            this.w = 16;
            this.h = 16;
        }
    }

    public int getSize() {
        return this.w;
    }

    public Sprite(Vector2 position, BufferedImage texture) {
        this(position.x, position.y, texture);
    }

    public Sprite(BufferedImage texture) {
        this(0.0f, 0.0f, texture);
    }

    public void addFrame(String name, int x, int y) {
        if (x < this.texture.getMinX()) {
            x = this.texture.getMinX();
        }
        if (y < this.texture.getMinY()) {
            y = this.texture.getMinY();
        }
        if (x > this.texture.getWidth()) {
            x = this.texture.getWidth();
        }
        if (y > this.texture.getHeight()) {
            y = this.texture.getHeight();
        }
        this.frames.put(name, new Vector2(x, y));
    }

    public void addFrame(String name, Vector2 pos) {
        this.addFrame(name, (int)pos.x, (int)pos.y);
    }

    public void removeFrame(String name) {
        this.frames.remove(name);
    }

    public BufferedImage getFrame(String name) {
        Vector2 framePos = this.frames.get(name);
        return this.texture.getSubimage((int)framePos.x, (int)framePos.y, this.w, this.h);
    }

    public boolean setCurrentFrame(String name) {
        if (this.frames.containsKey(name)) {
            this.currentFrame = name;
            return true;
        }
        return false;
    }

    public BufferedImage getCurrentFrame() {
        return this.getFrame(this.currentFrame);
    }

    public String getCurrentFrameString() {
        return this.currentFrame;
    }

    public Vector2 getPosition() {
        return this.position;
    }

    public float getX() {
        return this.position.x;
    }

    public float getY() {
        return this.position.y;
    }

    public void setPosition(Vector2 position) {
        this.position = new Vector2(position);
    }

    public void setPosition(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public void setX(float x) {
        this.position.x = x;
    }

    public void setY(float y) {
        this.position.y = y;
    }

    public void setDirection(String dir) {
        this.direction = dir;
    }

    public String getDirection() {
        return this.direction;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int compareTo(Sprite s) {
        if (s.getPriority() < this.priority) {
            return -1;
        }
        if (s.getPriority() > this.priority) {
            return 1;
        }
        if (s.getPriority() == this.priority) {
            return 0;
        }
        return 0;
    }

    public void setFlipH(boolean flip) {
        if (this.allowFlip) {
            this.flipH = flip;
        }
    }

    public boolean isHFlipped() {
        return this.flipH;
    }

    public boolean isHidden() {
        return this.hide;
    }

    public void hide(boolean hide) {
        this.hide = hide;
    }

    public void setAllowFlip(boolean bool) {
        this.allowFlip = bool;
    }
}

