/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.model;

import com.rymeco.daam.controller.CtrPlayer;
import com.rymeco.daam.model.AbsEntity;
import com.rymeco.daam.model.HitBox;
import com.rymeco.daam.model.Sprite;
import com.rymeco.daam.util.Vector2;
import java.awt.image.BufferedImage;

public class Teleporter
extends AbsEntity {
    private Teleporter destination;
    private CtrPlayer target;
    private long cooldown;
    private boolean canTeleport = true;

    public Teleporter(Vector2 position, BufferedImage texture) {
        this.sprite = new Sprite(position, texture);
        this.sprite.addFrame("anim1", 0, 176);
        this.sprite.addFrame("anim2", 16, 176);
        this.sprite.addFrame("anim3", 32, 176);
        this.sprite.addFrame("anim4", 48, 176);
        this.sprite.addFrame("anim5", 64, 176);
        this.sprite.addFrame("anim6", 80, 176);
        this.position = position;
        this.sprite.setPriority(12);
        HitBox hit = new HitBox(this.getX() + 2.0f, this.getY() + 2.0f, 12.0f, 12.0f);
        this.setHitBox(hit);
    }

    public Teleporter(float x, float y, BufferedImage texture) {
        this(new Vector2(x, y), texture);
    }

    public CtrPlayer getTarget() {
        return this.target;
    }

    public void setTarget(CtrPlayer p) {
        this.target = p;
    }

    public void setDestination(Teleporter dest) {
        this.destination = dest;
    }

    public Teleporter getDestination() {
        return this.destination;
    }

    @Override
    public float getX() {
        return this.position.x;
    }

    @Override
    public float getY() {
        return this.position.y;
    }

    @Override
    public void setPosition(Vector2 position) {
        this.setPosition(position.x, position.y);
    }

    @Override
    public void setPosition(float x, float y) {
        this.setX(x);
        this.setY(y);
    }

    @Override
    public void setX(float x) {
        this.position.x = x;
        this.sprite.setX(x);
        this.hitbox.setX(x);
    }

    @Override
    public void setY(float y) {
        this.position.y = y;
        this.sprite.setY(y);
        this.hitbox.setY(y);
    }

    @Override
    public Sprite getSprite() {
        return this.sprite;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(long cooldown) {
        this.cooldown = cooldown;
    }

    public boolean canTeleport() {
        return this.canTeleport;
    }

    public void setCanTeleport(boolean canTeleport) {
        this.canTeleport = canTeleport;
    }
}

