/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.model;

import com.rymeco.daam.model.Sprite;
import com.rymeco.daam.util.Vector2;
import java.awt.image.BufferedImage;

public class Weapon {
    private final String name;
    private Sprite sprite;
    private final int ammo;
    private int ammoLeft;
    private final float rof;
    private final float damage;
    private final float range;
    private final boolean auto;

    public Weapon(String name, BufferedImage tileset, int ammo, float rof, float damage, float range, boolean auto) {
        this.name = name;
        this.ammo = ammo;
        this.ammoLeft = ammo;
        this.rof = rof;
        this.damage = damage;
        this.range = range;
        this.auto = auto;
        this.sprite = new Sprite(new Vector2(0.0f, 0.0f), tileset);
        this.assignSpr();
    }

    public void assignSpr() {
        if (this.getName().equals("rocketlauncher")) {
            this.sprite.addFrame("idle", 48, 112);
        } else if (this.getName().equals("railgun")) {
            this.sprite.addFrame("idle", 16, 112);
        } else if (this.getName().equals("shotgun")) {
            this.sprite.addFrame("idle", 32, 112);
        } else {
            this.sprite.addFrame("idle", 0, 112);
        }
        this.sprite.setCurrentFrame("idle");
    }

    public String getName() {
        return this.name;
    }

    public Sprite getSpr() {
        return this.sprite;
    }

    public int getAmmo() {
        return this.ammo;
    }

    public int getAmmoLeft() {
        return this.ammoLeft;
    }

    public void setAmmoLeft(int ammo) {
        this.ammoLeft = ammo;
    }

    public float getRof() {
        return this.rof;
    }

    public float getDamage() {
        return this.damage;
    }

    public float getRange() {
        return this.range;
    }

    public boolean getAuto() {
        return this.auto;
    }
}

