/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.model.enemies;

import com.rymeco.daam.GameConsts;
import com.rymeco.daam.automata.IEntity;
import com.rymeco.daam.model.AbsEntity;
import com.rymeco.daam.model.Sprite;
import com.rymeco.daam.util.Vector2;

public class AbsEnemy
extends AbsEntity {
    protected float speed;
    protected float range;
    protected int maxHealth;
    protected int health;
    protected String direction;
    protected IEntity target;
    protected GameConsts.EnemyID id;
    protected int damage;

    public AbsEnemy(GameConsts.EnemyID id, int maxHealth, float range, float speed, String direction, int damage) {
        this.id = id;
        this.maxHealth = maxHealth;
        this.health = maxHealth;
        this.range = range;
        this.speed = speed;
        this.direction = direction;
        this.damage = damage;
    }

    public GameConsts.EnemyID getID() {
        return this.id;
    }

    public IEntity getTarget() {
        return this.target;
    }

    public void setTarget(IEntity target) {
        this.target = target;
    }

    public float getRange() {
        return this.range;
    }

    public void setRange(float range) {
        this.range = range;
    }

    public void damage(int damage) {
        if (damage > this.getHealth()) {
            this.health = 0;
        } else {
            this.health -= damage;
            this.getSprite().hide(true);
        }
    }

    public int getHealth() {
        return this.health;
    }

    public void setHealth(int health) {
        this.health = health > this.maxHealth ? this.maxHealth : health;
    }

    public void heal() {
        this.health = this.maxHealth;
    }

    public void kill() {
        this.health = 0;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    @Override
    public Sprite getSprite() {
        return this.sprite;
    }

    public void setDirection(String dir) {
        if (!(dir.equals("N") || dir.equals("S") || dir.equals("E") || dir.equals("W") || dir.equals("NE") || dir.equals("NW") || dir.equals("SE") || dir.equals("SW"))) {
            dir = "N";
        }
        this.direction = dir;
        this.sprite.setDirection(dir);
    }

    public String getDirection() {
        return this.direction;
    }

    @Override
    public Vector2 getPosition() {
        return this.position;
    }

    @Override
    public float getX() {
        return this.position.x;
    }

    @Override
    public float getY() {
        return this.position.y;
    }

    @Override
    public void setPosition(Vector2 position) {
        this.setPosition(position.x, position.y);
    }

    @Override
    public void setPosition(float x, float y) {
        this.setX(x);
        this.setY(y);
    }

    @Override
    public void setX(float x) {
        this.position.x = x;
        this.sprite.setX(x);
    }

    @Override
    public void setY(float y) {
        this.position.y = y;
        this.sprite.setY(y);
    }

    public int getDamage() {
        return this.damage;
    }

    public void setDamge(int damage) {
        this.damage = damage;
    }
}

