/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.model.enemies;

import com.rymeco.daam.GameConsts;
import com.rymeco.daam.model.HitBox;
import com.rymeco.daam.model.Sprite;
import com.rymeco.daam.model.enemies.AbsEnemy;
import com.rymeco.daam.util.Vector2;
import java.awt.image.BufferedImage;

public class Lava
extends AbsEnemy {
    private long lifeTime;

    public Lava(Vector2 position, BufferedImage texture, long lifeTime) {
        super(GameConsts.EnemyID.LAVA, 100, 100.0f, 2.0f, "N", 1);
        this.sprite = new Sprite(position, texture);
        this.position = new Vector2(position);
        this.lifeTime = lifeTime;
        this.sprite.addFrame("anim1", 32, 64);
        this.sprite.addFrame("anim2", 48, 64);
        this.sprite.addFrame("anim3", 64, 64);
        this.sprite.addFrame("anim4", 80, 64);
        this.sprite.setPriority(15);
        HitBox hitbox = new HitBox(position.x + 2.0f, position.y + 4.0f, 14.0f, 10.0f);
        this.setHitBox(hitbox);
    }

    public Lava(int x, int y, BufferedImage texture, int lifeTime) {
        this(new Vector2(x, y), texture, lifeTime);
    }

    public long getLifeTime() {
        return this.lifeTime;
    }

    public void setLifeTime(long lifeTime) {
        this.lifeTime = lifeTime;
    }

    public void reduceLifeTime(long time) {
        if (this.lifeTime != -1L) {
            this.lifeTime = this.lifeTime - time < 0L ? 0L : (this.lifeTime -= time);
        }
    }
}

