/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.util;

public class Vector2 {
    public float x;
    public float y;

    public Vector2(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vector2(Vector2 v) {
        this.x = v.x;
        this.y = v.y;
    }

    public Vector2() {
        this(0.0f, 0.0f);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vector2)) {
            return false;
        }
        return this.equals((Vector2)obj);
    }

    public boolean equals(Vector2 other) {
        return this.x == other.x && this.y == other.y;
    }

    public double distanceTo(Vector2 v) {
        return Vector2.distance(this, v);
    }

    public static double distance(Vector2 a, Vector2 b) {
        float v0 = b.x - a.x;
        float v1 = b.y - a.y;
        return Math.sqrt(v0 * v0 + v1 * v1);
    }

    public Vector2 add(Vector2 other) {
        return Vector2.add(this, other);
    }

    public static Vector2 add(Vector2 a, Vector2 b) {
        Vector2 c = new Vector2();
        c.x = a.x + b.x;
        c.y = a.y + b.y;
        return c;
    }

    public Vector2 multiply(float alpha) {
        return Vector2.multiply(this, alpha);
    }

    public static Vector2 multiply(Vector2 v, float alpha) {
        Vector2 c = new Vector2();
        c.x = v.x * alpha;
        c.y = v.y * alpha;
        return c;
    }

    public void normalize() {
        double length = this.norm();
        if (length != 0.0) {
            this.x = (float)((double)this.x / length);
            this.y = (float)((double)this.y / length);
        }
    }

    public void rotate(double angle) {
        double x2 = Math.cos(angle) * (double)this.x - Math.sin(angle) * (double)this.y;
        double y2 = Math.sin(angle) * (double)this.x + Math.cos(angle) * (double)this.y;
        this.x = (int)x2;
        this.y = (int)y2;
    }

    public void translate(Vector2 v) {
        this.x += v.x;
        this.y += v.y;
    }

    public float scalarProduct(Vector2 other) {
        return Vector2.scalarProduct(this, other);
    }

    public static float scalarProduct(Vector2 u, Vector2 v) {
        return u.x * v.x + u.y * v.y;
    }

    public double norm() {
        return Vector2.norm(this);
    }

    public static double norm(Vector2 u) {
        return Math.sqrt(u.x * u.x + u.y * u.y);
    }

    public double angleBetween(Vector2 other) {
        return Vector2.angleBetween(this, other);
    }

    public static double angleBetween(Vector2 u, Vector2 v) {
        double cos = (double)Vector2.scalarProduct(u, v) / (u.norm() * v.norm());
        return Math.toDegrees(Math.acos(cos));
    }
}

