/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.util.audio;

import com.rymeco.daam.util.audio.AudioPlayer;
import com.rymeco.daam.util.audio.OggPlayer;
import com.rymeco.daam.util.events.IAudioListener;
import java.io.InputStream;
import java.util.ArrayList;

public class AudioManager {
    float m_musicVol;
    InputStream m_musicInputStream;
    AudioPlayer m_musicPlayer;
    AudioPlayer[] m_players = new AudioPlayer[10];
    ArrayList<IAudioListener> m_listeners = new ArrayList();
    int m_nplayers;

    public void playMusic(InputStream is, long duration, float vol) {
        if (!is.markSupported()) {
            throw new IllegalArgumentException("Input stream must support mark/reset");
        }
        this._playMusic(is, duration, vol);
    }

    public void setVolume(float vol) {
        if (vol < 0.0f) {
            vol = 0.0f;
        }
        if (vol > 1.0f) {
            vol = 1.0f;
        }
        this.m_musicVol = vol;
        if (this.m_musicPlayer != null) {
            this.m_musicPlayer.setVolume(vol);
        }
    }

    public float getVolume() {
        return this.m_musicVol;
    }

    public void stopMusic(String name) {
        this._stopMusic(name);
    }

    public void playSound(String name, InputStream is, long duration, float vol) {
        this._playSound(name, is, duration, vol);
    }

    public void stopAll() {
        this._stopPlayers();
    }

    private void _playMusic(InputStream is, long duration, float vol) {
        if (this.m_musicPlayer != null) {
            this.m_musicPlayer.stop();
        }
        this.m_musicPlayer = new OggPlayer(this);
        this.m_musicVol = vol;
        this.m_musicInputStream = is;
        this.m_musicInputStream.mark(Integer.MAX_VALUE);
        this.m_musicPlayer.playMusic("music", is, duration, vol);
    }

    private void _stopMusic(String name) {
        if (this.m_musicPlayer != null) {
            this.m_musicPlayer.stop();
            this.m_musicPlayer = null;
        }
    }

    public void onStop(AudioPlayer player) {
        int i = 0;
        while (i < this.m_nplayers) {
            if (player == this.m_players[i]) {
                this.m_players[i].stop();
                ++i;
                while (i < this.m_nplayers) {
                    this.m_players[i - 1] = this.m_players[i];
                    ++i;
                }
                this.m_players[i - 1] = null;
                --this.m_nplayers;
            }
            ++i;
        }
    }

    private void _playSound(String name, InputStream is, long duration, float vol) {
        AudioPlayer player;
        if (this.m_nplayers >= this.m_players.length) {
            player = this.m_players[0];
            player.stop();
            int i = 1;
            while (i < this.m_nplayers) {
                this.m_players[i - 1] = this.m_players[i];
                ++i;
            }
            this.m_players[this.m_nplayers - 1] = null;
            --this.m_nplayers;
        }
        player = new OggPlayer(this);
        this.m_players[this.m_nplayers++] = player;
        player.playSound(name, is, duration, vol);
    }

    private void _stopPlayers() {
        if (this.m_musicPlayer != null) {
            this.m_musicPlayer.stop();
            this.m_musicPlayer = null;
        }
        int i = 0;
        while (i < this.m_nplayers) {
            this.m_players[i].stop();
            this.m_players[i] = null;
            ++i;
        }
        this.m_nplayers = 0;
    }

    public void onAudioEnd(AudioPlayer player, String name) {
        for (IAudioListener l : this.m_listeners) {
            l.onAudioEnd(name);
        }
    }

    public void addAudioListener(IAudioListener l) {
        this.m_listeners.add(l);
    }

    public void removeAudioListener(IAudioListener l) {
        this.m_listeners.remove(l);
    }

    public void clearAudioListeners() {
        this.m_listeners.clear();
    }
}

