/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.util.audio;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import com.rymeco.daam.util.audio.AudioManager;
import com.rymeco.daam.util.audio.AudioPlayer;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class OggPlayer
extends AudioPlayer
implements Runnable {
    private String m_name;
    private float m_volume;
    private Thread m_worker;
    private final boolean m_debugMode = false;
    private static final boolean PLAY_VERBOSE = false;
    private InputStream m_inputStream;
    byte[] m_buffer;
    int m_bufferSize;
    int m_count;
    int m_length;
    int m_index;
    byte[] m_convertedBuffer;
    int m_convertedBufferSize;
    private SourceDataLine m_outputLine;
    private float[][][] m_pcmInfo;
    private int[] m_pcmIndex;
    private Packet m_joggPacket;
    private Page m_joggPage;
    private StreamState m_joggStreamState;
    private SyncState m_joggSyncState;
    private DspState m_jorbisDspState;
    private Block jorbisBlock;
    private Comment m_jorbisComment;
    private Info m_jorbisInfo;
    private volatile boolean m_stop;
    private long m_duration;
    private long m_startOfPlay = -1L;
    private long m_endOfPlay = -1L;
    private boolean m_loop;
    static Object lock = new Object();

    public OggPlayer(AudioManager manager) {
        super(manager);
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void setVolume(float vol) {
        if (this.m_outputLine != null) {
            if (vol < 0.0f) {
                vol = 0.0f;
            }
            if (vol > 1.0f) {
                vol = 1.0f;
            }
            this.m_volume = vol;
            FloatControl volumeControl = (FloatControl)this.m_outputLine.getControl(FloatControl.Type.MASTER_GAIN);
            float min = volumeControl.getMinimum();
            float max = volumeControl.getMaximum();
            float db = (float)Math.log(vol) * 20.0f;
            if (db > max) {
                db = max;
            }
            if (db < min) {
                db = min;
            }
            volumeControl.setValue(db);
        }
    }

    @Override
    public float getVolume() {
        return this.m_volume;
    }

    @Override
    public void stop() {
        this.m_stop = true;
        this.m_worker.interrupt();
    }

    @Override
    public void playMusic(String name, InputStream is, long duration, float volume) {
        this.m_name = name;
        this.m_volume = volume;
        this.m_inputStream = is;
        this.m_duration = duration;
        this.m_loop = true;
        is.mark(Integer.MAX_VALUE);
        if (this.m_worker != null) {
            this.m_stop = true;
            this.m_worker.interrupt();
        } else {
            this.m_worker = new Thread((Runnable)this, "AudioPlayer:" + name);
            this.m_worker.start();
        }
    }

    @Override
    public void playSound(String name, InputStream is, long duration, float volume) {
        this.m_name = name;
        this.m_volume = volume;
        this.m_inputStream = is;
        this.m_duration = duration;
        if (this.m_worker != null) {
            this.m_stop = true;
            this.m_worker.interrupt();
        } else {
            this.m_worker = new Thread((Runnable)this, "AudioPlayer:" + name);
            this.m_worker.start();
        }
    }

    @Override
    public void run() {
        block17: {
            try {
                try {
                    while (true) {
                        this.m_inputStream.reset();
                        this.m_startOfPlay = System.currentTimeMillis();
                        if (this.m_duration > 0L) {
                            this.m_endOfPlay = this.m_startOfPlay + this.m_duration;
                        }
                        this.initializeJOrbis();
                        if (this.readHeader()) {
                            if (this.initializeSound()) {
                                this.debugOutput("Reading the body. length=" + this.m_length);
                                this.readBody();
                                this.debugOutput("Done reading the body. length=" + this.m_length);
                            } else {
                                System.out.println("Failed initializing sound");
                            }
                        } else {
                            System.out.println("Failed reading header");
                        }
                        if (this.m_loop && !this.m_stop) {
                            this.cleanUp();
                            this.m_inputStream.reset();
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ex) {
                    this.debugOutput("Got exception=" + ex);
                    this.cleanUp();
                    break block17;
                }
            }
            catch (Throwable throwable) {
                this.cleanUp();
                throw throwable;
            }
            this.cleanUp();
        }
        try {
            this.m_audioManager.onAudioEnd(this, this.m_name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.m_inputStream != null) {
                this.m_inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_audioManager.onStop(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeJOrbis() {
        this.debugOutput("Initializing JOrbis.");
        Object object = lock;
        synchronized (object) {
            this.m_joggPacket = new Packet();
            this.m_joggPage = new Page();
            this.m_joggStreamState = new StreamState();
            this.m_joggSyncState = new SyncState();
            this.m_jorbisDspState = new DspState();
            this.jorbisBlock = new Block(this.m_jorbisDspState);
            this.m_jorbisComment = new Comment();
            this.m_jorbisInfo = new Info();
            this.m_joggSyncState.init();
            this.m_index = 0;
            this.m_bufferSize = 2048;
            this.m_joggSyncState.buffer(this.m_bufferSize);
            this.m_buffer = this.m_joggSyncState.data;
        }
        this.debugOutput("Done initializing JOrbis.");
    }

    private boolean readHeader() throws IOException {
        this.debugOutput("Starting to read the header.");
        boolean needMoreData = true;
        int packet = 1;
        this.m_index = 0;
        this.m_bufferSize = 2048;
        while (needMoreData) {
            this.m_count = this.m_inputStream.read(this.m_buffer, this.m_index, this.m_bufferSize);
            if (this.m_count == -1) {
                this.debugOutput(" end of stream");
                return false;
            }
            this.m_length += this.m_count;
            this.debugOutput(" read " + this.m_count + " bytes, index=" + this.m_index);
            if (this.m_joggSyncState.wrote(this.m_count) < 0) {
                this.debugError("SyncState wrote error", null);
                return false;
            }
            block0 : switch (packet) {
                case 1: {
                    switch (this.m_joggSyncState.pageout(this.m_joggPage)) {
                        case -1: {
                            this.debugOutput("There is a hole in the first packet data.");
                            return false;
                        }
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.m_joggStreamState.init(this.m_joggPage.serialno());
                            this.m_joggStreamState.reset();
                            this.m_jorbisInfo.init();
                            this.m_jorbisComment.init();
                            if (this.m_joggStreamState.pagein(this.m_joggPage) == -1) {
                                this.debugError("We got an error while reading the first header page.", null);
                                return false;
                            }
                            if (this.m_joggStreamState.packetout(this.m_joggPacket) != 1) {
                                this.debugError("We got an error while reading the first header packet.", null);
                                return false;
                            }
                            if (this.m_jorbisInfo.synthesis_headerin(this.m_jorbisComment, this.m_joggPacket) < 0) {
                                this.debugError("We got an error while interpreting the first packet. Apparantly, it's not Vorbis data.", null);
                                return false;
                            }
                            ++packet;
                        }
                    }
                    if (packet == 1) break;
                }
                case 2: 
                case 3: {
                    switch (this.m_joggSyncState.pageout(this.m_joggPage)) {
                        case -1: {
                            this.debugError("There is a hole in the second or third packet data.", null);
                            return false;
                        }
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            this.m_joggStreamState.pagein(this.m_joggPage);
                            switch (this.m_joggStreamState.packetout(this.m_joggPacket)) {
                                case -1: {
                                    this.debugError("There is a hole in the firstpacket data.", null);
                                    return false;
                                }
                                case 0: {
                                    break block0;
                                }
                                case 1: {
                                    this.m_jorbisInfo.synthesis_headerin(this.m_jorbisComment, this.m_joggPacket);
                                    if (++packet != 4) break block0;
                                    needMoreData = false;
                                }
                            }
                        }
                    }
                }
            }
            this.m_index = this.m_joggSyncState.buffer(this.m_bufferSize);
            this.m_buffer = this.m_joggSyncState.data;
            if (this.m_count != 0 || !needMoreData) continue;
            this.debugOutput("Not enough header data was supplied.");
            return false;
        }
        this.debugOutput("Finished reading the header. index=" + this.m_index);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean initializeSound() {
        this.debugOutput("Initializing the sound system.");
        Object object = lock;
        synchronized (object) {
            this.m_convertedBufferSize = this.m_bufferSize * 2;
            this.m_convertedBuffer = new byte[this.m_convertedBufferSize];
            this.m_jorbisDspState.synthesis_init(this.m_jorbisInfo);
            this.jorbisBlock.init(this.m_jorbisDspState);
            int channels = this.m_jorbisInfo.channels;
            int rate = this.m_jorbisInfo.rate;
            AudioFormat audioFormat = new AudioFormat(rate, 16, channels, true, false);
            DataLine.Info datalineInfo = new DataLine.Info(SourceDataLine.class, audioFormat, -1);
            if (!AudioSystem.isLineSupported(datalineInfo)) {
                System.err.println("Audio output line is not supported.");
                return false;
            }
            try {
                this.m_outputLine = (SourceDataLine)AudioSystem.getLine(datalineInfo);
                this.m_outputLine.open(audioFormat);
                this.setVolume(this.m_volume);
            }
            catch (LineUnavailableException exception) {
                System.err.println("The audio output line could not be opened due to resource restrictions.");
                System.err.println(exception);
                return false;
            }
            catch (IllegalStateException exception) {
                System.err.println("The audio output line is already open.");
                System.err.println(exception);
                return false;
            }
            catch (SecurityException exception) {
                System.err.println("The audio output line could not be opened due to security restrictions.");
                System.err.println(exception);
                return false;
            }
            catch (Throwable th) {
                System.err.println("The audio initialization failed.");
                System.err.println(th);
                return false;
            }
            this.m_outputLine.start();
            this.m_pcmInfo = new float[1][][];
            this.m_pcmIndex = new int[this.m_jorbisInfo.channels];
        }
        this.debugOutput("Done initializing the sound system.");
        return true;
    }

    private void readBody() throws IOException {
        boolean needMoreData = true;
        while (needMoreData) {
            long now;
            if (this.m_stop) {
                return;
            }
            if (this.m_endOfPlay != -1L && this.m_endOfPlay <= (now = System.currentTimeMillis())) {
                System.out.println("Reached duration=" + this.m_duration);
                return;
            }
            switch (this.m_joggSyncState.pageout(this.m_joggPage)) {
                case -1: {
                    this.debugOutput("There is a hole in the data. We proceed.");
                }
                case 0: {
                    break;
                }
                case 1: {
                    this.m_joggStreamState.pagein(this.m_joggPage);
                    if (this.m_joggPage.granulepos() == 0L) {
                        needMoreData = false;
                        break;
                    }
                    block11: while (true) {
                        if (this.m_stop) {
                            return;
                        }
                        if (this.m_endOfPlay != -1L && this.m_endOfPlay <= (now = System.currentTimeMillis())) {
                            return;
                        }
                        switch (this.m_joggStreamState.packetout(this.m_joggPacket)) {
                            case -1: {
                                this.debugOutput("There is a hole in the data, we continue though.");
                            }
                            case 0: {
                                break block11;
                            }
                            case 1: {
                                this.decodeCurrentPacket();
                            }
                            default: {
                                continue block11;
                            }
                        }
                        break;
                    }
                    if (this.m_joggPage.eos() == 0) break;
                    needMoreData = false;
                }
            }
            if (!needMoreData) continue;
            this.m_index = this.m_joggSyncState.buffer(this.m_bufferSize);
            if (this.m_index < 0) {
                this.debugOutput(" end of stream index=" + this.m_index);
                return;
            }
            this.m_buffer = this.m_joggSyncState.data;
            this.m_count = this.m_inputStream.read(this.m_buffer, this.m_index, this.m_bufferSize);
            if (this.m_count == -1) {
                this.debugOutput(" end of stream");
                return;
            }
            this.debugOutput(" read " + this.m_count + " bytes, index=" + this.m_index);
            this.m_length += this.m_count;
            if (this.m_joggSyncState.wrote(this.m_count) < 0) {
                this.debugError("SyncState wrote error", null);
                return;
            }
            if (this.m_count != 0) continue;
            needMoreData = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp() {
        this.debugOutput("Cleaning up.");
        Object object = lock;
        synchronized (object) {
            if (this.m_outputLine != null) {
                this.m_outputLine.drain();
                this.m_outputLine.stop();
                this.m_outputLine.flush();
                this.m_outputLine.close();
                this.m_outputLine = null;
            }
            this.m_joggStreamState.clear();
            this.jorbisBlock.clear();
            this.m_jorbisDspState.clear();
            this.m_jorbisInfo.clear();
            this.m_joggSyncState.clear();
            this.m_stop = false;
            this.m_startOfPlay = -1L;
            this.m_endOfPlay = -1L;
            this.m_index = 0;
            this.debugOutput("Done cleaning up.");
        }
    }

    private void decodeCurrentPacket() {
        int samples;
        if (this.jorbisBlock.synthesis(this.m_joggPacket) == 0) {
            this.m_jorbisDspState.synthesis_blockin(this.jorbisBlock);
        }
        while ((samples = this.m_jorbisDspState.synthesis_pcmout(this.m_pcmInfo, this.m_pcmIndex)) > 0) {
            int range = samples < this.m_convertedBufferSize ? samples : this.m_convertedBufferSize;
            int i = 0;
            while (i < this.m_jorbisInfo.channels) {
                int sampleIndex = i * 2;
                int j = 0;
                while (j < range) {
                    int value = (int)(this.m_pcmInfo[0][i][this.m_pcmIndex[i] + j] * 32767.0f);
                    if (value > Short.MAX_VALUE) {
                        value = Short.MAX_VALUE;
                    }
                    if (value < Short.MIN_VALUE) {
                        value = Short.MIN_VALUE;
                    }
                    if (value < 0) {
                        value |= 0x8000;
                    }
                    this.m_convertedBuffer[sampleIndex] = (byte)value;
                    this.m_convertedBuffer[sampleIndex + 1] = (byte)(value >>> 8);
                    sampleIndex += 2 * this.m_jorbisInfo.channels;
                    ++j;
                }
                ++i;
            }
            this.m_outputLine.write(this.m_convertedBuffer, 0, 2 * this.m_jorbisInfo.channels * range);
            this.m_jorbisDspState.synthesis_read(range);
        }
    }

    private void debugOutput(String output) {
    }

    private void debugError(String output, Throwable reason) {
        if (reason != null) {
            reason.printStackTrace(System.err);
        }
        System.err.println("OggPlayer: " + output);
    }
}

