/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.view;

import com.rymeco.daam.GameConsts;
import com.rymeco.daam.controller.CtrMenu;
import com.rymeco.daam.util.Vector2;
import java.awt.image.BufferedImage;

public class Button {
    private BufferedImage btnUp;
    private BufferedImage btnDown;
    private BufferedImage btn;
    private Vector2 coord;
    private Vector2 dim;
    private String name;
    private boolean pressed = false;
    private boolean active = true;

    public Button() {
        this.coord = new Vector2();
        this.dim = new Vector2();
    }

    public Button(BufferedImage up, BufferedImage down, int x, int y, int w, int h, String name) {
        this.coord = new Vector2(x, y);
        this.dim = new Vector2(w, h);
        this.btnUp = up;
        this.btnDown = down;
        this.btn = this.btnUp;
        this.name = name;
    }

    public void setPos(int x, int y) {
        this.coord.x = x;
        this.coord.y = y;
    }

    public int getX() {
        return (int)this.coord.x;
    }

    public int getY() {
        return (int)this.coord.y;
    }

    public int getW() {
        return (int)this.dim.x;
    }

    public int getH() {
        return (int)this.dim.y;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void press(boolean pressed) {
        this.pressed = pressed;
        this.btn = this.isPressed() ? this.btnDown : this.btnUp;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public BufferedImage getBtn() {
        return this.btn;
    }

    public void effect(CtrMenu ctr) {
        switch (this.getName()) {
            case "play": {
                ctr.setGameState(GameConsts.GameState.GAME);
                break;
            }
            case "options": {
                ctr.getViewMenu().setCurrentState(GameConsts.MenuState.OPTIONS);
                break;
            }
            case "quit": {
                ctr.quit();
                break;
            }
            case "credits": {
                ctr.getViewMenu().setCurrentState(GameConsts.MenuState.CREDITS);
                break;
            }
            case "stats": {
                ctr.getViewMenu().setCurrentState(GameConsts.MenuState.STATS);
                break;
            }
            case "controls": {
                ctr.getViewMenu().setCurrentState(GameConsts.MenuState.CONTROLS);
                break;
            }
            case "music": {
                ctr.setMusic(!ctr.getMusic());
                break;
            }
            default: {
                ctr.getViewMenu().setCurrentState(GameConsts.MenuState.MAIN);
            }
        }
    }

    public boolean isInside(int x, int y) {
        return x >= this.getX() && x <= this.getX() + this.getW() && y >= this.getY() && y <= this.getY() + this.getH();
    }
}

