/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.view;

import com.rymeco.daam.util.events.ICanvasListener;
import com.rymeco.daam.util.events.IKeyboardListener;
import com.rymeco.daam.util.events.IMouseBtnListener;
import com.rymeco.daam.util.events.IMouseMoveListener;
import com.rymeco.daam.view.IView;
import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.Timer;

public class GameCanvas
extends Canvas {
    static final int TICK_PERIOD = 1;
    static final double FPS = 60.0;
    static final int REPAINT_DELAY = 16;
    private static final long serialVersionUID = 1L;
    private Image m_buffer1;
    private Image m_buffer2;
    private Image m_renderBuffer;
    private Image m_drawBuffer;
    private int m_width;
    private int m_height;
    private boolean m_swap;
    private ArrayList<ICanvasListener> m_canvasListeners;
    private ArrayList<IKeyboardListener> m_keyboardListeners;
    private ArrayList<IMouseBtnListener> m_mouseBtnListeners;
    private ArrayList<IMouseMoveListener> m_mouseMoveListeners;
    private ArrayList<IView> m_views;
    Timer m_timer;
    long m_elapsed;
    long m_lastRepaint;
    long m_lastTick;
    long m_lastSec;
    int m_nTicks;
    int m_fps;
    int m_npaints;
    float m_tickPeriod;
    WindowFrame m_frame;
    EventQueue eventQueue;
    Timer m_delayTimer;

    public GameCanvas() {
        System.setProperty("sun.awt.noerasebackground", "true");
        this.m_canvasListeners = new ArrayList();
        this.m_keyboardListeners = new ArrayList();
        this.m_mouseBtnListeners = new ArrayList();
        this.m_mouseMoveListeners = new ArrayList();
        this.m_views = new ArrayList();
        this.setBackground(Color.gray);
        this.addKeyListener(new KeyListener());
        this.addMouseListener(new MouseListener());
        this.addMouseMotionListener(new MouseMotionListener());
        this.setFocusable(true);
        this.requestFocusInWindow();
    }

    @Override
    public int getWidth() {
        return this.m_width;
    }

    @Override
    public int getHeight() {
        return this.m_height;
    }

    public int getDrawWidth() {
        return this.m_drawBuffer.getWidth(null);
    }

    public int getDrawHeight() {
        return this.m_drawBuffer.getHeight(null);
    }

    public void setTimer(int delay) {
        this._setTimer(delay);
    }

    public void cancelTimer() {
        this._cancelTimer();
    }

    public void addView(IView v) {
        this.m_views.add(v);
    }

    public void removeView(IView v) {
        this.m_views.remove(v);
    }

    public void addCanvasListener(ICanvasListener l) {
        this.m_canvasListeners.add(l);
    }

    public void addKeyboardListener(IKeyboardListener l) {
        this.m_keyboardListeners.add(l);
    }

    public void addMouseBtnListener(IMouseBtnListener l) {
        this.m_mouseBtnListeners.add(l);
    }

    public void addMouseMoveListener(IMouseMoveListener l) {
        this.m_mouseMoveListeners.add(l);
    }

    public boolean removeCanvasListener(ICanvasListener l) {
        return this.m_canvasListeners.remove(l);
    }

    public boolean removeKeyboardListener(IKeyboardListener l) {
        return this.m_keyboardListeners.remove(l);
    }

    public boolean removeMouseBtnListener(IMouseBtnListener l) {
        return this.m_mouseBtnListeners.remove(l);
    }

    public boolean removeMouseMoveListener(IMouseMoveListener l) {
        return this.m_mouseMoveListeners.remove(l);
    }

    private void initDoubleBuffering(int width, int height) {
        if (width != this.m_width || height != this.m_height) {
            this.m_width = width;
            this.m_height = height;
            this.m_buffer1 = new BufferedImage(this.m_width, this.m_height, 1);
            this.m_buffer2 = new BufferedImage(this.m_width, this.m_height, 1);
            Graphics gc = this.m_buffer1.getGraphics();
            gc.setColor(this.getBackground());
            gc.fillRect(0, 0, this.m_width, this.m_height);
            gc = this.m_buffer2.getGraphics();
            gc.setColor(this.getBackground());
            gc.fillRect(0, 0, this.m_width, this.m_height);
            this.m_renderBuffer = this.m_buffer2;
            this.m_drawBuffer = this.m_buffer1;
        }
    }

    private void swap() {
        if (this.m_renderBuffer == this.m_buffer1) {
            this.m_renderBuffer = this.m_buffer2;
            this.m_drawBuffer = this.m_buffer1;
        } else {
            this.m_renderBuffer = this.m_buffer1;
            this.m_drawBuffer = this.m_buffer2;
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (width > 0 && height > 0) {
            this.initDoubleBuffering(width, height);
            if (this.m_timer == null) {
                this.createTimer();
            }
        }
    }

    @Override
    public final void paint(Graphics g) {
        if (this.m_swap) {
            this.swap();
            this.m_swap = false;
        }
        g.drawImage(this.m_renderBuffer, 0, 0, this);
        Toolkit.getDefaultToolkit().sync();
    }

    @Override
    public final void update(Graphics g) {
        this.paint(g);
    }

    public int getFPS() {
        return this.m_fps;
    }

    public float getTickPeriod() {
        return this.m_tickPeriod;
    }

    private void createTimer() {
        int tick = 1;
        this.m_lastTick = System.currentTimeMillis();
        this.m_timer = new Timer(tick, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameCanvas.this.tick();
            }
        });
        this.m_timer.start();
    }

    private void tick() {
        long now = System.currentTimeMillis();
        long elapsed = now - this.m_lastTick;
        this.m_elapsed += elapsed;
        this.m_lastTick = now;
        ++this.m_nTicks;
        if (now - this.m_lastSec > 1000L) {
            this.m_fps = this.m_npaints;
            this.m_lastSec = now;
            this.m_npaints = 0;
        }
        for (ICanvasListener l : this.m_canvasListeners) {
            if (!l.isInitialized()) continue;
            l.onTick(elapsed);
        }
        elapsed = now - this.m_lastRepaint;
        if (elapsed > 16L) {
            this.m_tickPeriod = (float)this.m_elapsed / (float)this.m_nTicks;
            this.m_tickPeriod = (float)((int)(this.m_tickPeriod * 10.0f)) / 10.0f;
            this.m_elapsed = 0L;
            this.m_nTicks = 0;
            this.m_lastRepaint = now;
            if (this.m_drawBuffer != null) {
                Graphics g = this.m_drawBuffer.getGraphics();
                for (IView v : this.m_views) {
                    if (!v.isInitialized()) continue;
                    v.render(g);
                }
                this.m_swap = true;
                ++this.m_npaints;
                this.repaint();
            }
        }
    }

    public void post(Runnable r) {
        this.eventQueue.postEvent(new RunnableEvent(this, r));
    }

    @Override
    protected void processEvent(AWTEvent event) {
        if (event instanceof RunnableEvent) {
            RunnableEvent tr = (RunnableEvent)event;
            tr.run();
        } else {
            super.processEvent(event);
        }
    }

    public JFrame createFrame(Dimension d) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.eventQueue = tk.getSystemEventQueue();
        this.m_frame = new WindowFrame();
        this.m_frame.setSize(d);
        this.m_frame.addWindowListener(new WindowListener());
        this.m_frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                for (ICanvasListener l : GameCanvas.this.m_canvasListeners) {
                    if (!l.isInitialized()) continue;
                    l.onWindowResize(e);
                }
            }
        });
        return this.m_frame;
    }

    private void _setTimer(int delay) {
        if (this.m_delayTimer != null) {
            throw new IllegalStateException("You may not set another timer, the current timer has not expired.");
        }
        this.m_delayTimer = new Timer(delay, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                boolean canceled;
                3 var3_2 = this;
                synchronized (var3_2) {
                    if (GameCanvas.this.m_delayTimer != null) {
                        GameCanvas.this.m_delayTimer.stop();
                        GameCanvas.this.m_delayTimer = null;
                        canceled = false;
                    } else {
                        canceled = true;
                    }
                }
                if (!canceled) {
                    for (ICanvasListener l : GameCanvas.this.m_canvasListeners) {
                        l.onExpired();
                    }
                }
            }
        });
        this.m_delayTimer.setRepeats(false);
        this.m_delayTimer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _cancelTimer() {
        GameCanvas gameCanvas = this;
        synchronized (gameCanvas) {
            if (this.m_delayTimer != null) {
                this.m_delayTimer.stop();
                this.m_delayTimer = null;
            }
        }
    }

    private class KeyListener
    implements java.awt.event.KeyListener {
        private KeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            for (IKeyboardListener l : GameCanvas.this.m_keyboardListeners) {
                if (!l.isInitialized()) continue;
                l.onKeyType(e);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            for (IKeyboardListener l : GameCanvas.this.m_keyboardListeners) {
                if (!l.isInitialized()) continue;
                l.onKeyPress(e);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            for (IKeyboardListener l : GameCanvas.this.m_keyboardListeners) {
                if (!l.isInitialized()) continue;
                l.onKeyRelease(e);
            }
        }
    }

    private class MouseListener
    implements java.awt.event.MouseListener {
        private MouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            for (IMouseBtnListener l : GameCanvas.this.m_mouseBtnListeners) {
                if (!l.isInitialized()) continue;
                l.onMouseClick(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            for (IMouseBtnListener l : GameCanvas.this.m_mouseBtnListeners) {
                if (!l.isInitialized()) continue;
                l.onMousePress(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            for (IMouseBtnListener l : GameCanvas.this.m_mouseBtnListeners) {
                if (!l.isInitialized()) continue;
                l.onMouseRelease(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            for (IMouseBtnListener l : GameCanvas.this.m_mouseBtnListeners) {
                if (!l.isInitialized()) continue;
                l.onMouseEnter(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            for (IMouseBtnListener l : GameCanvas.this.m_mouseBtnListeners) {
                if (!l.isInitialized()) continue;
                l.onMouseExit(e);
            }
        }
    }

    private class MouseMotionListener
    implements java.awt.event.MouseMotionListener {
        private MouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            for (IMouseMoveListener l : GameCanvas.this.m_mouseMoveListeners) {
                if (!l.isInitialized()) continue;
                l.onMouseDrag(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            for (IMouseMoveListener l : GameCanvas.this.m_mouseMoveListeners) {
                if (!l.isInitialized()) continue;
                l.onMouseMove(e);
            }
        }
    }

    public class RunnableEvent
    extends AWTEvent
    implements Runnable {
        private static final long serialVersionUID = 1L;
        public static final int EVENT_ID = 2000;
        Runnable runnable;

        RunnableEvent(Object target, Runnable runnable) {
            super(target, 2000);
            this.runnable = runnable;
        }

        @Override
        public void run() {
            this.runnable.run();
        }
    }

    class WindowFrame
    extends JFrame {
        private static final long serialVersionUID = 1L;

        WindowFrame() {
            this.enableEvents(2000L);
        }
    }

    private class WindowListener
    implements java.awt.event.WindowListener {
        WindowListener() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
            for (ICanvasListener l : GameCanvas.this.m_canvasListeners) {
                if (!l.isInitialized()) continue;
                l.onWindowOpen();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            GameCanvas.this.m_canvasListeners.clear();
            GameCanvas.this.m_keyboardListeners.clear();
            GameCanvas.this.m_mouseBtnListeners.clear();
            GameCanvas.this.m_mouseMoveListeners.clear();
            System.exit(0);
        }

        @Override
        public void windowClosed(WindowEvent e) {
            System.exit(0);
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }
    }
}

