/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.view;

import com.rymeco.daam.AssetManager;
import com.rymeco.daam.controller.CtrGame;
import com.rymeco.daam.controller.enemies.CtrExplosion;
import com.rymeco.daam.controller.enemies.CtrLava;
import com.rymeco.daam.controller.enemies.CtrPouf;
import com.rymeco.daam.model.Sprite;
import com.rymeco.daam.util.Timer;
import com.rymeco.daam.util.Vector2;
import com.rymeco.daam.view.IView;
import com.rymeco.daam.view.ViewGame;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class Minimap
implements IView {
    private Vector2 pos;
    private ViewGame viewGame;
    private Image surface;
    private BufferedImage hudEmpty;
    private BufferedImage healthBar;
    private BufferedImage dashBar;
    private int surfaceW;
    private float ratio = 0.03f;
    private int maxPlayHealth;
    private int oldHealth = 100;
    private int oldHealthW = 99;
    private int playHealth;
    private long dashTimer;
    private long healthTimer;
    private long maxDashTimer;
    private Sprite playWeaponSpr;
    private int ammoLeft;
    private int waveCounter = 1;
    private long startingTimer;
    private boolean initialised;
    private CtrGame controller;
    private Timer gameTimer;

    public Minimap(ViewGame viewGame, CtrGame controller) {
        this.controller = controller;
        this.viewGame = viewGame;
        this.pos = new Vector2();
        this.setWidth(48);
        BufferedImage tileset = AssetManager.getTexture("spritesheet");
        this.hudEmpty = tileset.getSubimage(0, 129, 126, 25);
        this.healthBar = tileset.getSubimage(0, 154, 99, 6);
        this.dashBar = tileset.getSubimage(0, 160, 85, 3);
        this.playWeaponSpr = new Sprite(tileset);
        this.playWeaponSpr.addFrame("rocketlauncher", 48, 112);
        this.playWeaponSpr.addFrame("railgun", 16, 112);
        this.playWeaponSpr.addFrame("shotgun", 32, 112);
        this.playWeaponSpr.addFrame("gun", 0, 112);
        this.playWeaponSpr.addFrame("none", 0, 240);
        this.playWeaponSpr.setCurrentFrame("none");
        this.gameTimer = new Timer();
        this.initialised = true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialised && this.controller.isInitialized();
    }

    @Override
    public void render(Graphics g) {
        this.renderMinimap();
        this.renderHUD(g);
        g.drawImage(this.surface, (int)this.pos.x, (int)this.pos.y, null);
    }

    public void setWidth(int width) {
        this.surfaceW = width;
        this.surface = new BufferedImage(this.surfaceW, 32, 2);
    }

    private void renderMinimap() {
        Vector2 sPos;
        Graphics2D g = (Graphics2D)this.surface.getGraphics();
        AlphaComposite comp = AlphaComposite.getInstance(1);
        g.setComposite(comp);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        comp = AlphaComposite.getInstance(3);
        g.setComposite(comp);
        g.setColor(new Color(3, 3, 3, 100));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int i = 0;
        while (i < this.controller.getEnemies().size()) {
            if (this.controller.getEnemies().get(i) instanceof CtrLava) {
                g.setColor(Color.orange);
            } else {
                if (this.controller.getEnemies().get(i) instanceof CtrPouf || this.controller.getEnemies().get(i) instanceof CtrExplosion) break;
                g.setColor(Color.red);
            }
            Vector2 sPos2 = this.computePos(this.controller.getEnemies().get(i).getPosition());
            g.fillOval((int)sPos2.x - 2, (int)sPos2.y - 2, 3, 3);
            ++i;
        }
        g.setColor(Color.green);
        for (Vector2 v : this.controller.getItemsPositions()) {
            sPos = this.computePos(v);
            g.fillOval((int)sPos.x - 2, (int)sPos.y - 2, 3, 3);
        }
        g.setColor(Color.white);
        for (Vector2 v : this.controller.getTeleportersPositions()) {
            sPos = this.computePos(v);
            g.fillOval((int)sPos.x - 2, (int)sPos.y - 2, 3, 3);
        }
        g.setColor(Color.cyan);
        Vector2 posPlayerMini = this.computePos(this.viewGame.getPlayerPos());
        g.fillOval((int)posPlayerMini.x - 2, (int)posPlayerMini.y - 2, 3, 3);
    }

    private void renderHUD(Graphics g) {
        BufferedImage h = this.healthBar.getSubimage(0, 0, this.computeHealthW(), this.healthBar.getHeight());
        BufferedImage d = this.dashBar.getSubimage(0, 0, this.computeDashW(), this.dashBar.getHeight());
        BufferedImage w = this.playWeaponSpr.getCurrentFrame();
        g.drawImage(this.hudEmpty, 5, 5, null);
        g.setColor(Color.red);
        g.fillRect(31, 6, this.computeRedW(), this.healthBar.getHeight());
        g.drawImage(h, 31, 6, null);
        g.drawImage(d, 31, 14, null);
        g.drawImage(w, 5, 5, null);
        g.setColor(Color.white);
        g.setFont(new Font("SansSerif", 0, 8));
        g.drawString(String.valueOf(this.getAmmoLeft()), 6, 28);
        g.drawString(this.gameTimer.toString(), this.viewGame.getWidth() - 50, this.viewGame.getHeight() - 10);
        g.drawString("WAVE " + this.waveCounter, (int)(this.getMinimapX() + (float)this.getWidth() - 30.0f), (int)(this.getMinimapY() + (float)this.getHeight() + 8.0f));
        if (this.startingTimer < 4000L) {
            g.setFont(new Font("SansSerif", 1, 20));
            g.drawString("WAVE " + this.waveCounter, this.viewGame.getWidth() / 2 - 45, this.viewGame.getHeight() / 2 + 60);
        }
    }

    public int getWidth() {
        return this.surface.getWidth(null);
    }

    public int getHeight() {
        return this.surface.getHeight(null);
    }

    @Override
    public void onTick(long elapsed) {
        this.healthTimer += elapsed;
        this.startingTimer += elapsed;
        this.gameTimer.update(elapsed);
        if (this.oldHealth != this.playHealth) {
            this.oldHealthW = Math.min(Math.round(99 * this.oldHealth / this.getMaxHealth()), 99);
            this.oldHealth = this.playHealth;
            this.setHealthTimer(0L);
        }
    }

    public Vector2 computePos(Vector2 posEntity) {
        return new Vector2(posEntity.x * this.ratio, posEntity.y * this.ratio);
    }

    public int computeHealthW() {
        if (this.getMaxHealth() == 0) {
            return 99;
        }
        int h = Math.min(Math.round(99 * this.getPlayHealth() / this.getMaxHealth()), 99);
        if (h <= 0) {
            return 1;
        }
        return h;
    }

    public int computeRedW() {
        if (this.healthTimer > 1000L) {
            this.oldHealthW = Math.min(Math.round(99 * this.getPlayHealth() / this.getMaxHealth()), 99);
            return Math.min(Math.round(99 * this.getPlayHealth() / this.getMaxHealth()), 99);
        }
        return this.oldHealthW;
    }

    public int computeDashW() {
        if (this.getMaxDashTimer() == 0L) {
            return 85;
        }
        int d = Math.min(Math.round(85L * this.getDashTimer() / this.getMaxDashTimer()), 85);
        if (d <= 0) {
            return 1;
        }
        return d;
    }

    public void setRatio(float ratio) {
        this.ratio = ratio;
    }

    public float getRatio() {
        return this.ratio;
    }

    public Vector2 getMinimapPos() {
        return this.pos;
    }

    public float getMinimapX() {
        return this.pos.x;
    }

    public float getMinimapY() {
        return this.pos.y;
    }

    public void setMinimapPos(Vector2 pos) {
        this.setMinimapPos(pos.x, pos.y);
    }

    public void setMinimapPos(float x, float y) {
        this.setMinimapX(x);
        this.setMinimapY(y);
    }

    public void setMinimapX(float x) {
        this.pos.x = x;
    }

    public void setMinimapY(float y) {
        this.pos.y = y;
    }

    public void setPlayHealth(int health) {
        this.playHealth = health;
    }

    public int getPlayHealth() {
        return this.playHealth;
    }

    public void setMaxHealth(int max) {
        this.maxPlayHealth = max;
    }

    public int getMaxHealth() {
        return this.maxPlayHealth;
    }

    public void setDashTimer(long timer) {
        this.dashTimer = timer;
    }

    public long getDashTimer() {
        return this.dashTimer;
    }

    public void setMaxDashTimer(long max) {
        this.maxDashTimer = max;
    }

    public long getMaxDashTimer() {
        return this.maxDashTimer;
    }

    public void setWeaponSpr(Sprite sprite) {
        this.playWeaponSpr = sprite;
    }

    public Sprite getWeaponSpr() {
        return this.playWeaponSpr;
    }

    public void setAmmoLeft(int ammoLeft) {
        this.ammoLeft = ammoLeft;
    }

    public int getAmmoLeft() {
        return this.ammoLeft;
    }

    public void setWeapon(String weapon) {
        this.playWeaponSpr.setCurrentFrame(weapon);
    }

    public void setHealthTimer(long l) {
        this.healthTimer = l;
    }

    public void upWaveCounter() {
        ++this.waveCounter;
    }

    public void resetStartingTimer() {
        this.startingTimer = 0L;
    }
}

