/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.view;

import com.rymeco.daam.AssetManager;
import com.rymeco.daam.view.IResizeableView;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class ViewEndScreen
implements IResizeableView {
    private Image surface;
    private boolean initialized;
    private boolean lost;
    private BufferedImage playDead;
    private BufferedImage player;
    private BufferedImage gasterolcan;
    private BufferedImage logo;

    public ViewEndScreen(boolean lost) {
        this.lost = lost;
        BufferedImage tileset = AssetManager.getTexture("spritesheet");
        BufferedImage gui = AssetManager.getTexture("menu_spritesheet");
        this.playDead = tileset.getSubimage(176, 0, 25, 16);
        this.player = tileset.getSubimage(48, 0, 16, 16);
        this.gasterolcan = tileset.getSubimage(0, 16, 16, 16);
        this.logo = gui.getSubimage(0, 100, 78, 50);
        this.initialized = true;
    }

    public int getWidth() {
        return this.surface.getWidth(null);
    }

    public int getHeight() {
        return this.surface.getHeight(null);
    }

    @Override
    public void render(Graphics g) {
        this.renderSurface();
        g.drawImage(this.surface, 0, 0, null);
    }

    private void renderSurface() {
        Graphics g = this.surface.getGraphics();
        if (this.lost) {
            this.renderLost(g);
        } else {
            this.renderWon(g);
        }
    }

    private void renderLost(Graphics g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(this.playDead, this.getWidth() / 2 - 8, this.getHeight() / 2 + 10, null);
        g.drawImage(this.gasterolcan, this.getWidth() / 2 - 64, this.getHeight() / 2 + 10, null);
        g.setColor(Color.white);
        g.setFont(new Font("SansSerif", 0, 10));
        g.drawString("?", this.getWidth() / 2 - 45, this.getHeight() / 2 + 10);
        g.setFont(new Font("SansSerif", 1, 22));
        g.drawString("GAME OVER", this.getWidth() / 2 - 70, this.getHeight() / 2 - 30);
    }

    private void renderWon(Graphics g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.yellow);
        g.setFont(new Font("SansSerif", 1, 25));
        g.drawString("VICTORY", this.getWidth() / 2 - 55, this.getHeight() / 2 - 60);
        g.setFont(new Font("SansSerif", 0, 10));
        g.setColor(Color.white);
        g.drawString("You defeated Satan Claus", this.getWidth() / 2 - 62, this.getHeight() / 2 - 40);
        g.drawImage(this.player, this.getWidth() / 2 - 8, this.getHeight() / 2 - 10, null);
        g.setFont(new Font("SansSerif", 0, 10));
        g.setColor(Color.white);
        g.drawString("Thanks for playing !", this.getWidth() / 2 - 46, this.getHeight() / 2 + 40);
        g.drawImage(this.logo, this.getWidth() / 2 - 39, this.getHeight() / 2 + 50, null);
    }

    @Override
    public void onTick(long elapsed) {
    }

    @Override
    public boolean isInitialized() {
        return this.initialized && this.surface != null;
    }

    @Override
    public void setSize(int w, int h) {
        this.surface = new BufferedImage(w, h, 1);
    }
}

