/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.view;

import com.rymeco.daam.controller.CtrGame;
import com.rymeco.daam.model.CylinderMap;
import com.rymeco.daam.model.Sprite;
import com.rymeco.daam.util.Vector2;
import com.rymeco.daam.view.Camera;
import com.rymeco.daam.view.IResizeableView;
import com.rymeco.daam.view.Minimap;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.PriorityQueue;

public class ViewGame
implements IResizeableView {
    private PriorityQueue<Sprite> sprites = new PriorityQueue();
    private Image surface;
    private boolean initialized;
    private Camera camera;
    private CylinderMap map;
    private int offsetMaxX;
    private int offsetMaxY;
    private Vector2 cursorPos;
    private long itemMoveElapsed;
    private Color colorWeapon;
    private Vector2 playerPos;
    private Minimap viewMinimap;
    private boolean canAdd;

    public ViewGame(Vector2 cursorPos, CtrGame controller) {
        this.cursorPos = cursorPos;
        this.camera = new Camera(0, 0);
        this.viewMinimap = new Minimap(this, controller);
        this.canAdd = true;
        this.initialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized && this.surface != null;
    }

    public Minimap getMinimap() {
        return this.viewMinimap;
    }

    public Vector2 getPlayerPos() {
        if (this.playerPos == null) {
            return new Vector2();
        }
        return this.playerPos;
    }

    public void setPlayerPos(Vector2 pos) {
        this.playerPos = pos;
    }

    public void addSprite(Sprite s) {
        if (this.canAdd) {
            this.sprites.add(s);
        }
    }

    public Color getColorWeapon() {
        return this.colorWeapon;
    }

    public void setColorWeapon(Color c) {
        this.colorWeapon = c;
    }

    public void setMap(CylinderMap map) {
        this.map = map;
    }

    public CylinderMap getMap() {
        return this.map;
    }

    public Vector2 getCursorPos() {
        return this.cursorPos;
    }

    public float getCursorX() {
        return this.cursorPos.x;
    }

    public float getCursorY() {
        return this.cursorPos.y;
    }

    public int getWidth() {
        return this.surface.getWidth(null);
    }

    public int getHeight() {
        return this.surface.getHeight(null);
    }

    @Override
    public void render(Graphics g) {
        this.renderSurface();
        g.drawImage(this.surface, 0, 0, null);
        if (this.viewMinimap.isInitialized()) {
            this.viewMinimap.render(g);
        }
    }

    private void computeCamera() {
        this.offsetMaxY = this.map.getHeight() - this.getHeight();
        if (this.camera.getY() > this.offsetMaxY) {
            this.camera.setY(this.offsetMaxY);
        } else if (this.camera.getY() < 0) {
            this.camera.setY(0);
        }
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void stopAddSprites() {
        this.canAdd = false;
    }

    public boolean canAddSprites() {
        return this.canAdd;
    }

    private void renderSurface() {
        Graphics g = this.surface.getGraphics();
        this.camera.setCamera((int)this.getPlayerPos().x + 8 - this.getWidth() / 2, (int)this.getPlayerPos().y + 8 - this.getHeight() / 2);
        this.computeCamera();
        g.translate(-this.camera.getX(), -this.camera.getY());
        while (this.sprites.size() > 0) {
            Sprite s = this.sprites.poll();
            BufferedImage img = s.getCurrentFrame();
            int x = (int)s.getX();
            int y = (int)s.getY();
            int w = img.getWidth();
            int h = img.getHeight();
            if (s.isHFlipped()) {
                w = -w;
                x += s.getSize();
            }
            g.drawImage(img, x, y, w, h, null);
        }
        this.canAdd = true;
    }

    @Override
    public void onTick(long elapsed) {
        this.viewMinimap.onTick(elapsed);
        this.itemMoveElapsed += elapsed;
        if ((double)this.itemMoveElapsed > 3141.592653589793) {
            this.itemMoveElapsed = 0L;
        }
    }

    @Override
    public void setSize(int w, int h) {
        this.surface = new BufferedImage(w, h, 1);
        float mw = this.getMap().getWidth();
        float mh = this.getMap().getHeight();
        int miniW = Math.round(mw * (float)this.viewMinimap.getHeight() / mh);
        this.viewMinimap.setWidth(miniW);
        this.viewMinimap.setMinimapPos(w - miniW - 8, 8.0f);
        this.viewMinimap.setRatio((float)miniW / mw);
    }
}

