/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.view;

import com.rymeco.daam.AssetManager;
import com.rymeco.daam.GameConsts;
import com.rymeco.daam.controller.CtrMain;
import com.rymeco.daam.model.Sprite;
import com.rymeco.daam.util.Vector2;
import com.rymeco.daam.view.Camera;
import com.rymeco.daam.view.GameCanvas;
import com.rymeco.daam.view.IResizeableView;
import com.rymeco.daam.view.IView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ViewMain
implements IView {
    private GameCanvas canvas;
    private BufferedImage cursor;
    private Vector2 cursorPos;
    private Sprite[] bulletSprites = new Sprite[30];
    private JFrame frame;
    private JLabel text;
    private JSlider volumeSlider;
    private Image surface;
    private int surfaceW;
    private long textElapsed;
    private boolean initialized;
    public Camera camera;
    private CtrMain controller;
    private IView currentView;
    private IView changingView;

    public ViewMain(CtrMain controller, GameCanvas canvas, JFrame frame) {
        this.cursorPos = new Vector2();
        this.canvas = canvas;
        this.frame = frame;
        this.controller = controller;
        canvas.addView(this);
        this.setupFrame();
        this.initialized = true;
    }

    public void setView(IView view) {
        if (this.currentView == null) {
            this.currentView = view;
        } else {
            this.changingView = view;
        }
    }

    private void addAutoOption(JMenu autoMenu, GameConsts.EnemyID id, String def) {
        ButtonGroup group = new ButtonGroup();
        for (String gal : AssetManager.availableGAL()) {
            JRadioButtonMenuItem radio = new JRadioButtonMenuItem(gal);
            group.add(radio);
            autoMenu.add(radio);
            radio.setActionCommand(gal);
            radio.addActionListener(new AutoRadioListener(id));
            if (!gal.equals(def)) continue;
            radio.setSelected(true);
        }
    }

    private void setupFrame() {
        this.frame.setTitle("DAAM");
        ArrayList<BufferedImage> icons = new ArrayList<BufferedImage>();
        icons.add(AssetManager.getTexture(GameConsts.TexFile.ICON_8.toString()));
        icons.add(AssetManager.getTexture(GameConsts.TexFile.ICON_16.toString()));
        icons.add(AssetManager.getTexture(GameConsts.TexFile.ICON_32.toString()));
        icons.add(AssetManager.getTexture(GameConsts.TexFile.ICON_64.toString()));
        icons.add(AssetManager.getTexture(GameConsts.TexFile.ICON_128.toString()));
        icons.add(AssetManager.getTexture(GameConsts.TexFile.ICON_256.toString()));
        this.frame.setIconImages(icons);
        this.frame.setLayout(new BorderLayout());
        this.frame.add((Component)this.canvas, "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu autoSettings = new JMenu("Automates");
        JMenu gasterolcanMenu = new JMenu("Gast\u00e9rolcan");
        this.addAutoOption(gasterolcanMenu, GameConsts.EnemyID.GASTEROLCAN, "gasterolcan");
        autoSettings.add(gasterolcanMenu);
        JMenu lavaBlobMenu = new JMenu("Blob de lave");
        this.addAutoOption(lavaBlobMenu, GameConsts.EnemyID.LAVA_BLOB, "lavablob");
        autoSettings.add(lavaBlobMenu);
        JMenu satanMenu = new JMenu("Satan Claus");
        this.addAutoOption(satanMenu, GameConsts.EnemyID.SATAN, "satan");
        autoSettings.add(satanMenu);
        JMenu tramoidMenu = new JMenu("Tramo\u00efde");
        this.addAutoOption(tramoidMenu, GameConsts.EnemyID.TRAMOID, "tramoid");
        autoSettings.add(tramoidMenu);
        JMenu zombieMenu = new JMenu("Zombie");
        this.addAutoOption(zombieMenu, GameConsts.EnemyID.ZOMBIE, "zombie");
        autoSettings.add(zombieMenu);
        JMenu lavaMenu = new JMenu("Lave");
        this.addAutoOption(lavaMenu, GameConsts.EnemyID.LAVA, "lava");
        autoSettings.add(lavaMenu);
        menuBar.add(autoSettings);
        JMenu volumeMenu = new JMenu("Volume");
        int vol = (int)(this.controller.getAudioVolume() * 100.0f);
        this.volumeSlider = new JSlider(0, 100, vol);
        this.volumeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                float vol = (float)((JSlider)e.getSource()).getValue() / 100.0f;
                ViewMain.this.controller.setAudioVolume(vol);
            }
        });
        volumeMenu.add(this.volumeSlider);
        menuBar.add(volumeMenu);
        JMenu viewMenu = new JMenu("Ecran");
        JMenuItem viewHomeBtn = new JMenuItem("Menu");
        viewHomeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewMain.this.controller.setGameState(GameConsts.GameState.MENU);
            }
        });
        viewMenu.add(viewHomeBtn);
        JMenuItem viewGameBtn = new JMenuItem("Jeu");
        viewGameBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewMain.this.controller.setGameState(GameConsts.GameState.GAME);
            }
        });
        viewMenu.add(viewGameBtn);
        menuBar.add(viewMenu);
        menuBar.add(new JSeparator());
        this.text = new JLabel();
        this.text.setText("Tick: 0ms FPS=0");
        this.text.setHorizontalAlignment(4);
        menuBar.add(this.text);
        this.frame.add((Component)menuBar, "North");
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
        BufferedImage cursorImg = new BufferedImage(16, 16, 2);
        Cursor crossCursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImg, new Point(0, 0), "blank cursor");
        this.canvas.setCursor(crossCursor);
    }

    @Override
    public boolean isInitialized() {
        return this.initialized && this.currentView != null && this.currentView.isInitialized();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void setSliderVolume(float vol) {
        this.volumeSlider.setValue((int)(vol * 100.0f));
    }

    public void setCursor(BufferedImage texture, int x, int y) {
        this.cursor = texture.getSubimage(x, y, 15, 15);
    }

    public void setCursor(BufferedImage texture, Vector2 pos) {
        this.setCursor(texture, (int)pos.x, (int)pos.y);
    }

    public Vector2 getCursorPos() {
        return this.cursorPos;
    }

    public float getCursorX() {
        return this.cursorPos.x;
    }

    public float getCursorY() {
        return this.cursorPos.y;
    }

    public void setCursorPos(Vector2 pos) {
        this.setCursorPos((int)pos.x, (int)pos.y);
    }

    public void setCursorPos(int x, int y) {
        this.setCursorX(x);
        this.setCursorY(y);
    }

    public void setCursorX(int x) {
        this.cursorPos.x = x * this.surface.getWidth(null) / this.getDrawWidth();
    }

    public void setCursorY(int y) {
        this.cursorPos.y = y * this.surface.getHeight(null) / this.getDrawHeight();
    }

    public void setBulletSprite(Sprite sprite, int index) {
        this.bulletSprites[index] = sprite;
    }

    public int getWidth() {
        return this.surface.getWidth(null);
    }

    public int getHeight() {
        return this.surface.getHeight(null);
    }

    public int getDrawWidth() {
        return this.canvas.getDrawWidth();
    }

    public int getDrawHeight() {
        return this.canvas.getDrawHeight();
    }

    @Override
    public void render(Graphics g) {
        if (this.changingView != null) {
            this.currentView = this.changingView;
            this.changingView = null;
        }
        this.renderSurface();
        int width = this.getDrawWidth();
        int height = this.getDrawHeight();
        g.drawImage(this.surface, 0, 0, width, height, null);
    }

    private void renderSurface() {
        Graphics g = this.surface.getGraphics();
        if (this.currentView != null && this.currentView.isInitialized()) {
            this.currentView.render(g);
        }
        this.renderCursor(g);
    }

    private void renderCursor(Graphics g) {
        int x = (int)this.cursorPos.x - 7;
        int y = (int)this.cursorPos.y - 7;
        int w = this.cursor.getWidth();
        int h = this.cursor.getHeight();
        g.drawImage(this.cursor, x, y, w, h, null);
    }

    @Override
    public void onTick(long elapsed) {
        this.textElapsed += elapsed;
        if (this.textElapsed > 1000L) {
            this.textElapsed = 0L;
            float period = this.canvas.getTickPeriod();
            int fps = this.canvas.getFPS();
            String txt = "Tick=" + period + "ms";
            while (txt.length() < 15) {
                txt = String.valueOf(txt) + " ";
            }
            txt = String.valueOf(txt) + fps + " fps   ";
            this.text.setText(txt);
        }
    }

    public void resizeSurface() {
        this.surfaceW = Math.round(224.0f * (float)this.getDrawWidth() / (float)this.getDrawHeight());
        this.surface = new BufferedImage(this.surfaceW, 224, 1);
        if (this.currentView instanceof IResizeableView) {
            ((IResizeableView)this.currentView).setSize(this.surfaceW, 224);
        }
    }

    private class AutoRadioListener
    implements ActionListener {
        private GameConsts.EnemyID id;

        AutoRadioListener(GameConsts.EnemyID id) {
            this.id = id;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ViewMain.this.controller.setEnemyAutomata(this.id, e.getActionCommand());
        }
    }
}

