/*
 * Decompiled with CFR 0.152.
 */
package com.rymeco.daam.view;

import com.rymeco.daam.AssetManager;
import com.rymeco.daam.GameConsts;
import com.rymeco.daam.model.Sprite;
import com.rymeco.daam.util.Vector2;
import com.rymeco.daam.view.Button;
import com.rymeco.daam.view.IResizeableView;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class ViewMenu
implements IResizeableView {
    private Image bg;
    private Image lava;
    private Image lava1;
    private Image lava2;
    private Image lava3;
    private Image introPoly;
    private Image introVentilo;
    private BufferedImage tuto;
    private BufferedImage logo;
    private BufferedImage credits;
    private BufferedImage playUp;
    private BufferedImage playDown;
    private BufferedImage optionsUp;
    private BufferedImage optionsDown;
    private BufferedImage quitUp;
    private BufferedImage quitDown;
    private BufferedImage controlsUp;
    private BufferedImage controlsDown;
    private BufferedImage backUp;
    private BufferedImage backDown;
    private BufferedImage creditsUp;
    private BufferedImage creditsDown;
    private Image surface;
    private GameConsts.MenuState state;
    private Sprite sprite;
    private Vector2 cursorPos;
    private ArrayList<Button> mainButtons;
    private ArrayList<Button> optButtons;
    private ArrayList<Button> difButtons;
    private ArrayList<Button> ctrButtons;
    private ArrayList<Button> statsButtons;
    private ArrayList<Button> curButtons;
    private long introTimer = 0L;
    private long bgTimer = 0L;
    private boolean initialized = false;

    public ViewMenu(Vector2 cursorPos, int w, int h) {
        BufferedImage gui = AssetManager.getTexture("menu_spritesheet");
        this.surface = new BufferedImage(w, h, 1);
        this.introPoly = AssetManager.getTexture("polyclaques");
        this.introVentilo = AssetManager.getTexture("studioventilo");
        this.mainButtons = new ArrayList();
        this.optButtons = new ArrayList();
        this.difButtons = new ArrayList();
        this.ctrButtons = new ArrayList();
        this.statsButtons = new ArrayList();
        this.cursorPos = cursorPos;
        int screenCenter = this.getWidth() / 2;
        this.bg = gui.getSubimage(0, 250, 398, 171);
        this.lava1 = gui.getSubimage(0, 421, 398, 53);
        this.lava2 = gui.getSubimage(0, 474, 398, 53);
        this.lava3 = gui.getSubimage(0, 527, 398, 53);
        this.lava = this.lava1;
        this.tuto = gui.getSubimage(0, 0, 130, 100);
        this.logo = gui.getSubimage(0, 100, 78, 50);
        this.credits = gui.getSubimage(266, 0, 132, 122);
        this.playUp = gui.getSubimage(160, 0, 83, 23);
        this.playDown = gui.getSubimage(160, 23, 83, 23);
        this.mainButtons.add(new Button(this.playUp, this.playDown, screenCenter - 41, 80, 83, 23, "play"));
        this.optionsUp = gui.getSubimage(160, 46, 83, 23);
        this.optionsDown = gui.getSubimage(160, 69, 83, 23);
        this.mainButtons.add(new Button(this.optionsUp, this.optionsDown, screenCenter - 41, 110, 83, 23, "options"));
        this.quitUp = gui.getSubimage(160, 92, 83, 23);
        this.quitDown = gui.getSubimage(160, 115, 83, 23);
        this.mainButtons.add(new Button(this.quitUp, this.quitDown, screenCenter - 41, 140, 83, 23, "quit"));
        this.controlsUp = gui.getSubimage(160, 138, 83, 23);
        this.controlsDown = gui.getSubimage(160, 161, 83, 23);
        this.optButtons.add(new Button(this.controlsUp, this.controlsDown, screenCenter - 41, 80, 83, 23, "controls"));
        this.backUp = gui.getSubimage(243, 0, 23, 23);
        this.backDown = gui.getSubimage(243, 23, 23, 23);
        this.optButtons.add(new Button(this.backUp, this.backDown, screenCenter - 41, 140, 23, 23, "back1"));
        this.difButtons.add(new Button(this.backUp, this.backDown, screenCenter - 11, 160, 23, 23, "back2"));
        this.statsButtons.add(new Button(this.backUp, this.backDown, screenCenter - 11, 170, 23, 23, "back3"));
        this.ctrButtons.add(new Button(this.backUp, this.backDown, screenCenter - 11, 170, 23, 23, "back4"));
        this.creditsUp = gui.getSubimage(243, 184, 83, 23);
        this.creditsDown = gui.getSubimage(243, 207, 83, 23);
        this.optButtons.add(new Button(this.creditsUp, this.creditsDown, screenCenter - 41, 110, 83, 23, "credits"));
        this.desactive(this.optButtons);
        this.desactive(this.difButtons);
        this.desactive(this.mainButtons);
        this.desactive(this.statsButtons);
        this.curButtons = this.mainButtons;
        BufferedImage texture = AssetManager.getTexture("spritesheet");
        this.sprite = new Sprite(new Vector2(100.0f, 100.0f), texture);
        this.sprite.addFrame("anim1", 224, 16);
        this.sprite.addFrame("anim2", 240, 16);
        this.sprite.addFrame("anim3", 0, 32);
        this.initialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized && this.surface != null;
    }

    public GameConsts.MenuState getCurrentState() {
        return this.state;
    }

    public void setCurrentState(GameConsts.MenuState state) {
        this.state = state;
        switch (state) {
            case MAIN: {
                this.curButtons = this.mainButtons;
                this.active(this.mainButtons);
                this.desactive(this.optButtons);
                this.desactive(this.difButtons);
                this.desactive(this.statsButtons);
                this.desactive(this.ctrButtons);
                break;
            }
            case OPTIONS: {
                this.curButtons = this.optButtons;
                this.active(this.optButtons);
                this.desactive(this.mainButtons);
                this.desactive(this.difButtons);
                this.desactive(this.statsButtons);
                this.desactive(this.ctrButtons);
                break;
            }
            case CREDITS: {
                this.curButtons = this.difButtons;
                this.active(this.difButtons);
                this.desactive(this.mainButtons);
                this.desactive(this.optButtons);
                this.desactive(this.statsButtons);
                this.desactive(this.ctrButtons);
                break;
            }
            case STATS: {
                this.curButtons = this.statsButtons;
                this.active(this.statsButtons);
                this.desactive(this.mainButtons);
                this.desactive(this.optButtons);
                this.desactive(this.difButtons);
                this.desactive(this.ctrButtons);
                break;
            }
            case CONTROLS: {
                this.curButtons = this.ctrButtons;
                this.active(this.ctrButtons);
                this.desactive(this.difButtons);
                this.desactive(this.mainButtons);
                this.desactive(this.optButtons);
                this.desactive(this.statsButtons);
                break;
            }
            case INTRO: {
                this.desactive(this.mainButtons);
                this.desactive(this.optButtons);
                this.desactive(this.difButtons);
                this.desactive(this.statsButtons);
                this.desactive(this.ctrButtons);
            }
        }
    }

    public float getCursorX() {
        return this.cursorPos.x;
    }

    public float getCursorY() {
        return this.cursorPos.y;
    }

    public Sprite getTramoid() {
        return this.sprite;
    }

    public long getIntroTimer() {
        return this.introTimer;
    }

    public void setIntroTimer(long l) {
        this.introTimer = l;
    }

    public void upIntroTimer(long elapsed) {
        this.introTimer += elapsed;
    }

    public void upBgTimer(long elapsed) {
        this.bgTimer += elapsed;
    }

    public long getBgTimer() {
        return this.bgTimer;
    }

    public int getWidth() {
        return this.surface.getWidth(null);
    }

    public int getHeight() {
        return this.surface.getHeight(null);
    }

    public ArrayList<Button> getMainButtons() {
        return this.mainButtons;
    }

    public ArrayList<Button> getOptButtons() {
        return this.optButtons;
    }

    public ArrayList<Button> getDifButtons() {
        return this.difButtons;
    }

    public ArrayList<Button> getButtons() {
        return this.curButtons;
    }

    public void desactive(ArrayList<Button> buttons) {
        for (Button b : buttons) {
            b.setActive(false);
        }
    }

    public void active(ArrayList<Button> buttons) {
        for (Button b : buttons) {
            b.setActive(true);
        }
    }

    @Override
    public void render(Graphics g) {
        switch (this.state) {
            case INTRO: {
                g.setColor(Color.BLACK);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.renderIntro(g);
                break;
            }
            case MAIN: {
                this.renderBg(g);
                this.renderMain(g);
                break;
            }
            case OPTIONS: {
                this.renderBg(g);
                this.renderOptions(g);
                break;
            }
            case STATS: {
                this.renderBg(g);
                this.renderStats(g);
                break;
            }
            case CREDITS: {
                this.renderBg(g);
                this.renderCredits(g);
                break;
            }
            case CONTROLS: {
                this.renderBg(g);
                this.renderControls(g);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void renderBg(Graphics g) {
        g.drawImage(this.bg, -this.bg.getWidth(null), 0, null);
        g.drawImage(this.bg, 0, 0, null);
        g.drawImage(this.bg, this.bg.getWidth(null), 0, null);
        int n = (int)(this.bgTimer % 5000L);
        this.lava = n < 1700 ? this.lava1 : (n < 3500 ? this.lava2 : this.lava3);
        g.drawImage(this.lava, -this.bg.getWidth(null), this.bg.getHeight(null), null);
        g.drawImage(this.lava, 0, this.bg.getHeight(null), null);
        g.drawImage(this.lava, this.bg.getWidth(null), this.bg.getHeight(null), null);
        g.drawImage(this.logo, this.getWidth() / 2 - 40, 15, null);
        g.drawImage(this.sprite.getCurrentFrame(), this.getWidth() / 2 - 100, 10, null);
        g.drawImage(this.sprite.getCurrentFrame(), this.getWidth() - 30, 20, null);
        g.drawImage(this.sprite.getCurrentFrame(), this.getWidth() / 2 + 50, 100, null);
        g.drawImage(this.sprite.getCurrentFrame(), 10, 160, null);
    }

    public void renderIntro(Graphics g) {
        Image m = this.getIntroTimer() < 2400L ? this.introPoly : this.introVentilo;
        int w = -1;
        int h = -1;
        if (this.getWidth() > this.getHeight()) {
            h = this.getHeight();
            w = h * m.getWidth(null) / m.getHeight(null);
        } else {
            w = this.getWidth();
            h = w * m.getHeight(null) / m.getWidth(null);
        }
        m = m.getScaledInstance(w, h, 1);
        int x = (this.getWidth() - m.getWidth(null)) / 2;
        int y = (this.getHeight() - m.getHeight(null)) / 2;
        g.drawImage(m, x, y, null);
    }

    public void renderMain(Graphics g) {
        for (Button b : this.mainButtons) {
            if (!b.isActive()) continue;
            g.drawImage(b.getBtn(), b.getX(), b.getY(), null);
        }
    }

    public void resizeAll() {
        for (Button b : this.mainButtons) {
            b.setPos(this.getWidth() / 2 - 41, b.getY());
        }
        for (Button b : this.optButtons) {
            b.setPos(this.getWidth() / 2 - 41, b.getY());
        }
        for (Button b : this.difButtons) {
            b.setPos(this.getWidth() / 2 - 11, b.getY());
        }
        for (Button b : this.ctrButtons) {
            b.setPos(this.getWidth() / 2 - 11, b.getY());
        }
    }

    public void renderOptions(Graphics g) {
        for (Button b : this.optButtons) {
            if (!b.isActive()) continue;
            g.drawImage(b.getBtn(), b.getX(), b.getY(), null);
        }
    }

    public void renderStats(Graphics g) {
        for (Button b : this.statsButtons) {
            if (!b.isActive()) continue;
            g.drawImage(b.getBtn(), b.getX(), b.getY(), null);
        }
        int col1 = this.getWidth() / 2 - 160;
        int col2 = this.getWidth() / 2 + 10;
        g.setFont(new Font("SansSerif", 0, 15));
        g.drawString("STATISTICS", this.getWidth() / 2 - 45, 80);
        g.setFont(new Font("SansSerif", 0, 11));
        g.drawString("Git commits : 356", col1, 100);
        g.drawString("Master branch broken : 0", col1, 115);
        g.drawString("Git reclone : 12", col1, 130);
        g.drawString("Lines of code : ~10500", col1, 145);
        g.drawString("Abused Gasterolcans : 0", col1, 160);
        g.drawString("Highest tick spike : 289 ms", col2, 100);
        g.drawString("Coffee counter : 32", col2, 115);
        g.setFont(new Font("SansSerif", 0, 10));
        g.drawString("Number of seconds in one minute : 60", col2, 130);
        g.drawString("Future nominations to Game Awards : 12", col2, 145);
        g.drawString("'References' to other games : 5", col2, 160);
    }

    public void renderCredits(Graphics g) {
        g.drawImage(this.credits, this.getWidth() / 2 - this.credits.getWidth() / 2, 30, null);
        for (Button b : this.difButtons) {
            if (!b.isActive()) continue;
            g.drawImage(b.getBtn(), b.getX(), b.getY(), null);
        }
    }

    public void renderControls(Graphics g) {
        g.drawImage(this.tuto, this.getWidth() / 2 - this.credits.getWidth() / 2, 70, null);
        for (Button b : this.ctrButtons) {
            if (!b.isActive()) continue;
            g.drawImage(b.getBtn(), b.getX(), b.getY(), null);
        }
    }

    @Override
    public void onTick(long elapsed) {
    }

    @Override
    public void setSize(int w, int h) {
        this.surface = new BufferedImage(w, h, 1);
        this.resizeAll();
    }
}

